<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Project Section Widget .
 *
 */
class Adina_Project_Section extends \Elementor\Widget_Base {

	public function get_name() {
		return 'adina_project_section';
	}

	public function get_title() {
		return esc_html__( 'Adina Project Section', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'adina-addons' ];
	}

    protected function register_controls() {

        // Start Project
        $this->start_controls_section(
			'Project',
			[
				'label' => esc_html__( 'Project', 'adina' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our Portfolio', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Explore our diverse range of solutions', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title_paragraph',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Our successful endeavors in providing personalized insurance solutions to our valued clients, discover how we provided comprehensive insurance.', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'tab_title',
			[
				'label'   => esc_html__( 'Tab Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Life Insurance', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'post_per_page',
            [
                'label'       => __('Numbar Of Post', 'adina'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'user emty value show all posts',
            ]
        );
        $repeater->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'adina'),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'label_block' => true,
                'options' => array(
                    'latest'   =>   __('Latest Post', 'adina'),
                    'selected' =>   __('Selected posts', 'adina'),
                ),
            ]
        );
        $repeater->add_control(
            'post__in',
            [
                'label' => __('Post In', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => get_all_projects(),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
					'post_by' => 'selected',
				]
            ]
        );
        $repeater->add_control(
            'order',
            [
                'label' => __('Order', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'project_lists',
            [
                'label' => __('Project Lists', 'adina'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
            
        );
		$this->end_controls_section();

        // Section style
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Section', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'section_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'section_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // SubTitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-section-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_full_margin',
            [
                'label' => __( 'Full Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-title-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-tab-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-5-tab-content p',
			]
		);
		$this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-tab-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Tab Title style
        $this->start_controls_section(
            'tab_title_style',
            [
                'label' => __( 'Tab Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-tab-list button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_title_active_color',
            [
                'label' => __( 'Hover/Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-tab-btn:hover, .td-portfolio-tab-btn.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tab_title_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-5-tab-list button',
			]
		);
        $this->add_responsive_control(
            'tab_title_item_margin',
            [
                'label' => __( 'Item Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-tab-list button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tab_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-tab-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Project Title style
        $this->start_controls_section(
            'project_title_style',
            [
                'label' => __( 'Project Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'project_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'project_title_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-5-title',
			]
		);
		$this->add_responsive_control(
            'project_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Project Category style
        $this->start_controls_section(
            'project_category_style',
            [
                'label' => __( 'Project Category', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'project_category_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'project_category_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-5-title-pre',
			]
		);
		$this->add_responsive_control(
            'project_category_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-5-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();


	}

    protected function render() {
        $settings = $this->get_settings_for_display();
        $project_lists = $settings['project_lists'];

        ?>
            <div class="td-portfolio-area td-grey-bg pt-140 pb-100">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="td-portfolio-5-title-wrap mb-75 wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                                <span class="td-section-title-pre mb-10"><?php echo esc_html( $settings['subtitle_text'] ); ?></span>
                                <h2 class="td-section-title"><?php echo adina_kses( $settings['title_text'] ); ?></h2>
                            </div>
                        </div>
                        <div class="col-lg-6 wow fadeInUp" data-wow-delay=".4s" data-wow-duration="1s">
                            <div class="td-portfolio-5-tab-content pt-50 mb-75">
                                <p class="mb-30"><?php echo adina_kses( $settings['title_paragraph'] ); ?></p>
                                <div class="nav td-portfolio-tab-btn-list td-portfolio-5-tab-list" id="v-pill-tab" role="tablist" aria-orientation="vertical">
                                    <?php foreach ($project_lists as $index => $item):
                                        // Setup the query arguments
                                        $number_of_post = !empty($item['post_per_page']) ? $item['post_per_page'] : -1;
                                        $query_args = [
                                            'post_type'      => 'adina_project',
                                            'order'          => $item['order'],
                                            'posts_per_page' => $number_of_post,
                                            'post_status'    => 'publish',
                                        ];
        
                                        // If "Post By" is selected, include the posts in the query
                                        if ('selected' === $item['post_by']) {
                                            $query_args['post__in'] = (array) $item['post__in'];
                                        }
        
                                        // Create a new WP_Query
                                        $args = new \WP_Query($query_args);
        
                                        if ($args->have_posts()):
                                            ?>
                                            <button class="td-portfolio-tab-btn nav-link <?php echo $index === 0 ? 'active' : ''; ?>" id="v-pills-portfolio-<?php echo $index + 1; ?>-tab" data-bs-toggle="pill" data-bs-target="#v-pills-portfolio-<?php echo $index + 1; ?>" type="button" role="tab" aria-controls="v-pills-portfolio-<?php echo $index + 1; ?>" aria-selected="true">
                                                <?php echo esc_html( $item['tab_title'] ); ?>
                                            </button>
                                            <?php
                                        endif;
                                        wp_reset_postdata();
                                    endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="td-portfolio-5-tab-wrap">
                                <div class="td-banking-img-wrapper tab-content" id="v-pill-tabContent">
                                    <?php foreach ($project_lists as $index => $item):
                                        // Reuse the same query arguments for the content
                                        $number_of_post = !empty($item['post_per_page']) ? $item['post_per_page'] : -1;
                                        $query_args = [
                                            'post_type'      => 'adina_project',
                                            'order'          => $item['order'],
                                            'posts_per_page' => $number_of_post,
                                            'post_status'    => 'publish',
                                        ];
        
                                        if ('selected' === $item['post_by']) {
                                            $query_args['post__in'] = (array) $item['post__in'];
                                        }
        
                                        // Create a new WP_Query for content
                                        $args = new \WP_Query($query_args);
        
                                        if ($args->have_posts()):
                                            ?>
                                            <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>" id="v-pills-portfolio-<?php echo $index + 1; ?>" role="tabpanel" aria-labelledby="v-pills-portfolio-<?php echo $index + 1; ?>-tab">
                                                <div class="row">
                                                    <?php while ($args->have_posts()): $args->the_post(); ?>
                                                        <div class="col-lg-6 mb-30 wow fadeInUp" data-wow-delay=".5s" data-wow-duration="1s">
                                                            <div class="td-portfolio-5-item p-relative">
                                                                <?php if (has_post_thumbnail()): ?>
                                                                    <div class="td-portfolio-5-thumb">
                                                                        <?php the_post_thumbnail('full'); ?>
                                                                        <span></span>
                                                                    </div>
                                                                <?php endif; ?>
                                                                <div class="td-portfolio-5-content">
                                                                    <span class="td-portfolio-5-title-pre">
                                                                        <?php
                                                                        $post_categories = get_the_terms(get_the_ID(), 'project_category');
                                                                        if (!empty($post_categories) && !is_wp_error($post_categories)):
                                                                            $category_names = wp_list_pluck($post_categories, 'name'); // Extract category names
                                                                            echo esc_html(implode(', ', $category_names)); // Join them with comma and space
                                                                        endif;
                                                                        ?>
                                                                    </span>
                                                                    <h3 class="td-portfolio-5-title">
                                                                        <a href="<?php the_permalink(); ?>">
                                                                            <?php the_title(); ?>
                                                                        </a>
                                                                    </h3>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endwhile; ?>
                                                </div>
                                            </div>
                                            <?php
                                        endif;
                                        wp_reset_postdata();
                                    endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
    

}

$widgets_manager->register( new \Adina_Project_Section() );