<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Project Slider Widget .
 *
 */
class Adina_project_Slider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'adina_project_slider';
	}

	public function get_title() {
		return esc_html__( 'project Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'adina-addons' ];
	}

    protected function register_controls() {

        // Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'adina'),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'project_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_responsive_control(
			'gap_right',
			[
				'label'          => __('Row Gap', 'adina'),
				'type'           => \Elementor\Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .td-portfolio-slider-active .swiper-slide, .td-portfolio-4-slider-active .swiper-slide' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);	
        $this->add_control(
            'post_per_page',
            [
                'label'       => __('Numbar Of Post', 'adina'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'user emty value show all posts',
            ]
        );
        $this->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'adina'),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'label_block' => true,
                'options' => array(
                    'latest'   =>   __('Latest Post', 'adina'),
                    'selected' =>   __('Selected posts', 'adina'),
                ),
            ]
        );
        $this->add_control(
            'post__in',
            [
                'label' => __('Post In', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => get_all_projects(),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
					'post_by' => 'selected',
				]
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
        $this->end_controls_section();
        // End Slider settings

        // Start project Section
        $this->start_controls_section(
			'project_section',
			[
				'label' => esc_html__( 'project Section', 'adina' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' =>[
					'project_layout' => 'layout-1'
				]
			]
		);
        $this->add_control(
			'show_btn',
			[
				'label'        => __( 'Show Button', 'adina' ),
				'type'         =>   \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'adina' ),
				'label_off'    => __( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'More Works', 'adina' ),
                'label_block' => true,
                'condition' =>[
					'show_btn' => 'yes'
				]
			]
		);
        $this->add_control(
			'btn_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
                'condition' =>[
					'show_btn' => 'yes'
				]
			]
		);
		$this->end_controls_section();

        // Tab Button style
        $this->start_controls_section(
            'tab_btn_style',
            [
                'label' => __( 'Tab Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' =>[
					'project_layout' => 'layout-1'
				]
            ]
        );
        $this->add_control(
            'tab_btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-tab-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_btn_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-tab-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tab_btn_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-tab-btn',
			]
		);
		$this->end_controls_section();

        // Button style
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' =>[
					'project_layout' => 'layout-1'
				]
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn, .td-btn-3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn, .td-btn-3' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .td-btn',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'btn_border',
				'selector' => '{{WRAPPER}} .td-btn, .td-btn-3',
			]
		);
        $this->add_responsive_control(
			'btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-arrow-svg-top-right' => 'fill: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-portfolio-thumb img, .td-portfolio-4-thumb img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-portfolio-thumb img, .td-portfolio-4-thumb img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Category style
        $this->start_controls_section(
            'category_style',
            [
                'label' => __( 'Category', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'category_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-portfolio-4-tag a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'category_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory span' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-portfolio-4-tag a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-cetagory span, {{WRAPPER}} .td-portfolio-4-tag a',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'category_border',
				'selector' => '{{WRAPPER}} .td-portfolio-cetagory span, {{WRAPPER}} .td-portfolio-4-tag a',
			]
		);
        $this->add_responsive_control(
			'category_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-portfolio-cetagory span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .td-portfolio-4-tag a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'category_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-portfolio-4-tag a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'category_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-portfolio-4-tag a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-portfolio-4-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-title, {{WRAPPER}} .td-portfolio-4-title',
			]
		);
		$this->end_controls_section();


	}


    protected function render() {
        $settings = $this->get_settings_for_display();
        $layout = $settings['project_layout'];

		?>
            <?php
                if ( $layout) {
                    include('project/'.$layout.'.php');
                }
            ?> 
		<?php
    }

}

$widgets_manager->register( new \Adina_project_Slider() );