<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Project Two Widget .
 *
 */
class Adina_Project_Two extends \Elementor\Widget_Base {

	public function get_name() {
		return 'adina_project_two';
	}

	public function get_title() {
		return esc_html__( 'Adina Project Two', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'adina-addons' ];
	}

    protected function register_controls() {

        // Start Project
        $this->start_controls_section(
			'Project_section',
			[
				'label' => esc_html__( 'Project', 'adina' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_responsive_control(
            'gap_right',
            [
                'label'          => __('Horizontal Gap', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .td-portfolio-wrap' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .td-banking-img-wrapper' => 'margin-right: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Vertical Gap', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .td-portfolio-wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .td-banking-img-wrapper' => 'margin-bottom: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'use_custom_height',
            [
                'label' => __('Use custom height?', 'adina'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_responsive_control(
            'normal_image_height',
            [
                'label' => __('Normal Image Height', 'adina'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .td-poerfolio-thumb img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'use_custom_height' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'post_per_page',
            [
                'label'       => __('Numbar Of Post', 'adina'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'user emty value show all posts',
            ]
        );
        $this->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'adina'),
                'type' => Controls_Manager::SELECT,
                'default' => 'selected',
                'label_block' => true,
                'options' => array(
                    'portfolio' => __('Portfolio', 'adina'),
                    'selected' =>   __('Selected posts', 'adina'),
                ),
            ]
        );
        $this->add_control(
            'post__in',
            [
                'label' => __('Post In', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => get_all_projects(),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
					'post_by' => 'selected',
				]
            ]
        );
        $this->add_control(
            'include_by',
            [
                'label'         => __('Include by', 'adina'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'label_block'   => true,
                'multiple'      => true,
                'options'       => [
                    'category'  => 'Category',
                ],
                'default' =>    [],
                'condition' => [
                    'post_by!' => 'selected'
                ],
            ]
        );
        $this->add_control(
            'include_categories',
            [
                'label'         => __('Include categories', 'adina'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific category(s)', 'adina'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => adina_cpt_taxonomy_slug_and_name('project_category'),
                'default' =>    [],
                'condition' => [
                    'include_by' => 'category',
                    'post_by!' => 'selected'
                ],
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
		$this->end_controls_section();


        // Tab Button style
        $this->start_controls_section(
            'tab_btn_style',
            [
                'label' => __( 'Tab Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab_btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-tab-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_btn_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-tab-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tab_btn_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-tab-btn',
			]
		);
		$this->end_controls_section();

        // Category style
        $this->start_controls_section(
            'category_style',
            [
                'label' => __( 'Category', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'category_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'category_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory span' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-cetagory span',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'category_border',
				'selector' => '{{WRAPPER}} .td-portfolio-cetagory span',
			]
		);
        $this->add_responsive_control(
			'category_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-portfolio-cetagory span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'category_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'category_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-cetagory span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-title',
			]
		);
		$this->end_controls_section();

	}

    protected function render() {
        $settings = $this->get_settings_for_display();
    
        ?>
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 pb-45">
                        <div class="nav td-portfolio-tab-btn-list d-flex justify-content-center" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                            <?php
                            // Fetch terms from the 'project_category' taxonomy
                            $categories = get_terms(array(
                                'taxonomy' => 'project_category',
                                'hide_empty' => true,
                            ));

                            // Initialize an empty array for the tax query
                            $include_categories = array();

                            if (!empty($settings['include_categories'])) {
                                $include_categories['tax_query'] = array(
                                    array(
                                        'taxonomy' => 'project_category',
                                        'field'    => 'slug',
                                        'terms'    => $settings['include_categories'], // User-selected categories
                                    ),
                                );
                            }

                            // Display only selected categories
                            foreach ($categories as $index => $category):
                                if (!empty($include_categories) && !in_array($category->slug, $settings['include_categories'])) {
                                    continue; // Skip categories not in the selected list
                                }
                                $active_class = $index === 0 ? 'active' : '';
                                ?>
                                <button class="td-portfolio-tab-btn nav-link <?php echo esc_attr($active_class); ?>"
                                        id="v-pills-<?php echo esc_attr($category->term_id); ?>-tab"
                                        data-bs-toggle="pill"
                                        data-bs-target="#v-pills-<?php echo esc_attr($category->term_id); ?>"
                                        type="button"
                                        role="tab"
                                        aria-controls="v-pills-<?php echo esc_attr($category->term_id); ?>"
                                        aria-selected="<?php echo $index === 0 ? 'true' : 'false'; ?>">
                                    <?php echo esc_html($category->name); ?>
                                </button>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
    
                <div class="row">
                    <div class="col-lg-12">
                        <div class="td-banking-img-wrapper tab-content" id="v-pills-tabContent">
                            <?php 
                            $is_first_category_active = true; // Track if the first category is active
                            foreach ($categories as $index => $category):
                                if (!empty($include_categories) && !in_array($category->slug, $settings['include_categories'])) {
                                    continue; // Skip categories not in the selected list
                                }
    
                                $number_of_post = !empty($settings['post_per_page']) ? $settings['post_per_page'] : -1;
    
                                // Set up the query args
                                $query_args = [
                                    'post_type'      => 'adina_project',
                                    'order'          => $settings['order'],
                                    'posts_per_page' => $number_of_post,
                                    'post_status'    => 'publish',
                                    'tax_query'      => [
                                        [
                                            'taxonomy' => 'project_category',
                                            'field'    => 'term_id',
                                            'terms'    => $category->term_id,
                                        ],
                                    ],
                                ];
    
                                // Check if "Post By" is set to "Selected"
                                if ('selected' === $settings['post_by']) {
                                    $query_args['post__in'] = (array) $settings['post__in'];
                                }
    
                                // Create a new WP_Query for content
                                $args = new \WP_Query($query_args);
    
                                // Start the tab content
                                ?>
                                <div class="tab-pane fade <?php echo $is_first_category_active ? 'show active' : ''; ?>" id="v-pills-<?php echo esc_attr($category->term_id); ?>" role="tabpanel" aria-labelledby="v-pills-<?php echo esc_attr($category->term_id); ?>-tab">
                                    <div class="row g-0">
                                        <?php if ($args->have_posts()): ?>
                                            <?php while ($args->have_posts()): $args->the_post(); ?>
                                                <div class="col-lg-6 col-md-6">
                                                    <div class="td-portfolio-wrap">
                                                        <?php if (has_post_thumbnail()): ?>
                                                            <div class="td-poerfolio-thumb mb-30">
                                                                <?php the_post_thumbnail('full'); ?>
                                                            </div>
                                                        <?php endif; ?>
    
                                                        <div class="td-portfolio-cetagory mb-20">
                                                            <?php
                                                            $post_categories = get_the_terms(get_the_ID(), 'project_category');
                                                            if (!empty($post_categories) && !is_wp_error($post_categories)):
                                                                $count = 0; // Initialize counter
                                                                foreach ($post_categories as $post_category):
                                                                    if ($count >= 3) break; // Stop after displaying 3 categories
                                                                    echo '<span><a href="' . esc_url(get_term_link($post_category)) . '">' . esc_html($post_category->name) . '</a></span>';
                                                                    $count++; // Increment counter
                                                                endforeach;
                                                            endif;
                                                            ?>
                                                        </div>
                                                        <h3 class="td-portfolio-title">
                                                            <a href="<?php the_permalink(); ?>">
                                                                <?php the_title(); ?>
                                                            </a>
                                                        </h3>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                        <?php else: ?>
                                            <div class="col-12">
                                                <p><?php echo esc_html__( 'No posts available in this category.', 'adina' ) ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php
                                wp_reset_postdata(); // Reset post data for next iteration
                                $is_first_category_active = false; // Set it to false after the first category
                            endforeach;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
    
       

    

}

$widgets_manager->register( new \Adina_Project_Two() );