<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Project Widget .
 *
 */
class Adina_Project extends \Elementor\Widget_Base {

	public function get_name() {
		return 'adina_project';
	}

	public function get_title() {
		return esc_html__( 'Adina Project', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'adina-addons' ];
	}

    protected function register_controls() {

        // Start Project
        $this->start_controls_section(
			'Project',
			[
				'label' => esc_html__( 'Project', 'adina' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'adina'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_project(),
            ]
        );
        $repeater->add_control(
			'project_number',
			[
				'label' => esc_html__( 'Project Number', 'adina' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default' => esc_html__( '01', 'adina' ),
			]
		);
        $this->add_control(
            'project_lists',
            [
                'label' => __('Project Lists', 'adina'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
            
        );
		$this->end_controls_section();

        // Number style
        $this->start_controls_section(
            'number_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'number_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-2-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'number_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-2-title-pre',
			]
		);
		$this->add_responsive_control(
            'number_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-2-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-2-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-2-title',
			]
		);
		$this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-2-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'title_border',
				'selector' => '{{WRAPPER}} .td-portfolio-2-border',
			]
		);
		$this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-portfolio-2-thumb img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-portfolio-2-thumb img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // shape style
        $this->start_controls_section(
            'shape_style',
            [
                'label' => __( 'Shape', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'shape_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-2-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();


	}

    // Get All Project
    public function get_all_project() {

        $wp_query = get_posts([
            'post_type' => 'adina_project',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $projects) {
            $options[$projects->ID] = $projects->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $project_lists = $settings['project_lists'];

        ?>
            <div class="td-portfolio-2-wrap">
                <?php foreach( $project_lists as $item ) : 
                    $args = new \WP_Query(array(
                        'post_type' => 'adina_project',
                        'post_status' => 'publish',
                        'post__in' => [$item['select_post']]
                    )); 
                    ?>
                    <?php while ($args->have_posts()) : $args->the_post(); ?>
                        <div class="td-portfolio-2-content td-portfolio-2-border scene p-relative d-flex align-items-end wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                            <span class="td-portfolio-2-title-pre">
                                <?php echo esc_html( $item[ 'project_number' ]  ); ?>
                            </span>
                            <h2 class="td-portfolio-2-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h2>
                            <?php if( has_post_thumbnail() ): ?>
                                <div class="td-portfolio-2-thumb-inner">
                                    <div class="td-portfolio-2-thumb p-relative">
                                        <?php the_post_thumbnail('full');?>
                                        <span class="td-portfolio-2-icon">
                                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M40 20.7633C36.4 15.8833 31.84 12.55 26.32 10.7633C26.8 11.0833 27.1733 11.3233 27.44 11.4833C31.92 14.55 35.04 18.8967 36.8 24.5233C36.9333 25.0033 36.9467 25.43 36.84 25.8033C36.7333 26.15 36.4933 26.4967 36.12 26.8433C34.9467 27.9367 33.5867 28.9367 32.04 29.8433C30.76 30.5633 29.2267 31.2833 27.44 32.0033C25.7067 32.67 24.0267 33.23 22.4 33.6833C24.5067 31.4433 25.84 28.91 26.4 26.0833C26.88 23.5767 26.7733 20.75 26.08 17.6033C25.8667 22.3767 24.12 26.4433 20.84 29.8033C18.4667 32.2567 15.6533 34.1233 12.4 35.4033C12.9067 34.79 13.6 33.9767 14.48 32.9633C16.96 30.11 18.1333 26.79 18 23.0033C17.9733 22.5767 18.0133 22.2167 18.12 21.9233C18.2533 21.6033 18.4533 21.2967 18.72 21.0033C19.7067 19.9367 20.3067 18.7633 20.52 17.4833C20.7333 16.2033 20.5333 14.9633 19.92 13.7633C19.3333 12.5633 18.3867 11.5633 17.08 10.7633C16.7867 12.63 15.64 13.8167 13.64 14.3233C14.3333 14.7233 15.4133 15.3633 16.88 16.2433H10.52L16.4 19.0433L16.28 19.4833C11.7467 18.3367 7.58667 18.8167 3.8 20.9233C3.53333 20.6033 3.33333 20.35 3.2 20.1633L2.72 19.5233C2.32 18.99 2.05333 18.59 1.92 18.3233C1.70667 17.87 1.66667 17.4433 1.8 17.0433C1.98667 16.5633 2.44 16.0967 3.16 15.6433L0.16 15.2433L0 14.8833L1.52 14.0433C3.33333 13.0833 4.70667 12.3767 5.64 11.9233L5.76 11.8433C6.42667 11.55 6.88 11.2833 7.12 11.0433C7.49333 10.67 7.69333 10.1767 7.72 9.56333C7.72 9.40333 7.82667 9.21667 8.04 9.00333C8.28 8.79 8.52 8.63 8.76 8.52333C9.42667 8.25667 10.2133 8.00333 11.12 7.76333C11.6267 7.65667 11.9467 7.47 12.08 7.20333C12.2133 6.91 12.2267 6.52333 12.12 6.04333C11.8 4.39 10.7867 3.25667 9.08 2.64333C10.1733 1.81667 11.4133 1.19 12.8 0.763333C13.84 0.443333 15.1333 0.189999 16.68 0.00333362L15.28 6.04333L15.56 6.16333L16.4 5.04333C17.0667 4.11 17.5867 3.43 17.96 3.00333L18.84 2.00333C19.5867 1.15 20.0933 0.616667 20.36 0.403333C20.7067 0.109999 21.0933 -0.0233343 21.52 0.00333362C21.8133 0.00333362 22.4267 0.123334 23.36 0.363334L25 0.763333C25.8533 0.949999 26.7733 1.25667 27.76 1.68333C28.3733 1.95 29.2933 2.39 30.52 3.00333L31.28 3.40333C29.28 3.56333 27.52 3.84333 26 4.24333C24.2133 4.72333 22.5867 5.41667 21.12 6.32333L22.16 6.12333C23.2533 5.91 24.08 5.79 24.64 5.76333C26.1333 5.71 28.3733 5.71 31.36 5.76333C32.0267 5.79 32.6667 5.96333 33.28 6.28333C33.8133 6.57667 34.3467 7.00333 34.88 7.56333C38.2133 11.1633 39.92 15.5633 40 20.7633ZM9.2 11.3633C10.0533 11.47 10.6 11.5233 10.84 11.5233C11.16 11.47 11.4133 11.2967 11.6 11.0033C11.7067 10.8167 11.88 10.31 12.12 9.48333L9.2 11.3633ZM16.08 21.8033C16.32 22.79 16.3733 23.7767 16.24 24.7633C16.1333 25.59 15.8667 26.47 15.44 27.4033C14.8267 28.71 13.9867 29.9633 12.92 31.1633C12.0133 32.1233 10.88 33.1367 9.52 34.2033C8.61333 34.8967 7.26667 35.9633 5.48 37.4033L3.08 39.3233C2.68 37.5633 2.70667 35.8033 3.16 34.0433C3.64 32.2833 4.42667 30.8967 5.52 29.8833C5.84 29.9633 6.30667 30.0833 6.92 30.2433C7.58667 30.43 8.08 30.55 8.4 30.6033C8.93333 30.71 9.4 30.7633 9.8 30.7633C10.2 30.7633 10.64 30.6167 11.12 30.3233C11.5467 30.0567 11.92 29.7367 12.24 29.3633C12.9867 28.5633 13.3067 27.67 13.2 26.6833C13.0933 25.6967 12.5467 24.5767 11.56 23.3233L13.48 22.6833C14.6 22.31 15.4667 22.0167 16.08 21.8033ZM13.68 20.8033C12.4 21.0167 11.1467 21.5367 9.92 22.3633C9.17333 22.8433 8.13333 23.6967 6.8 24.9233C6.02667 25.6167 5.44 26.1233 5.04 26.4433L4.76 26.1233V25.4033C4.73333 24.4167 4.74667 23.6967 4.8 23.2433C4.82667 23.03 4.90667 22.83 5.04 22.6433C5.17333 22.43 5.33333 22.27 5.52 22.1633C6.72 21.4433 8.02667 20.9767 9.44 20.7633C10.72 20.5767 12.1333 20.59 13.68 20.8033Z" fill="#20282D" />
                                        </svg>
                                        </span>
                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>
                    <?php endwhile; wp_reset_postdata(); ?>
                <?php endforeach; ?>
            </div>
        <?php
    }

}

$widgets_manager->register( new \Adina_Project() );