<div class="row align-items-center pb-10">
    <div class="col-lg-8 pb-30">
        <div class="nav td-portfolio-tab-btn-list" id="v-pills-tab" role="tablist" aria-orientation="vertical">
            <?php 
            // Fetch terms from the 'project_category' taxonomy
            $categories = get_terms(array(
                'taxonomy' => 'project_category',
                'hide_empty' => true,
            ));

            // Check if there are any categories and limit to the first 7
            if (!empty($categories) && !is_wp_error($categories)):
                // Slice the array to get only the first 7 categories
                $categories = array_slice($categories, 0, 7);

                foreach ($categories as $index => $category):
                    $active_class = $index === 0 ? 'active' : '';
                    ?>
                    <button class="td-portfolio-tab-btn nav-link <?php echo esc_attr($active_class); ?>" 
                            id="v-pills-<?php echo esc_attr($category->term_id); ?>-tab" 
                            data-bs-toggle="pill" 
                            data-bs-target="#v-pills-<?php echo esc_attr($category->term_id); ?>" 
                            type="button" 
                            role="tab" 
                            aria-controls="v-pills-<?php echo esc_attr($category->term_id); ?>" 
                            aria-selected="<?php echo $index === 0 ? 'true' : 'false'; ?>">
                        <?php echo esc_html($category->name); ?>
                    </button>
                <?php 
                endforeach;
            endif; 
            ?>
        </div>
    </div>

    <?php if ('yes' === $settings['show_btn']) : ?>
        <div class="col-lg-4 pb-30">
            <div class="td-portfolio-right-btn text-right">
                <a class="td-btn td-btn-3 td-left-right" href="<?php echo esc_url($settings['btn_link']['url']); ?>">
                    <?php echo esc_html($settings['btn_text']); ?>
                    <span class="td-arrow-angle ml-10">
                        <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                        </svg>
                    </span>
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>

<div class="row">
    <div class="col-12">
        <div class="td-banking-img-wrapper tab-content" id="v-pills-tabContent">
            <?php foreach ($categories as $index => $category): ?>
                <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>" id="v-pills-<?php echo esc_attr($category->term_id); ?>" role="tabpanel" aria-labelledby="v-pills-<?php echo esc_attr($category->term_id); ?>-tab">
                    <div class="td-portfolio-slider-active swiper-container">
                        <div class="swiper-wrapper">
                            <?php 
                                $number_of_post = !empty($settings['post_per_page']) ? $settings['post_per_page'] : -1;
                                
                                // Set up the query args
                                $query_args = [
                                    'post_type'      => 'adina_project',
                                    'order'          => $settings['order'],
                                    'posts_per_page' => $number_of_post,
                                    'post_status'    => 'publish',
                                    'tax_query'      => [
                                        [
                                            'taxonomy' => 'project_category',
                                            'field'    => 'term_id',
                                            'terms'    => $category->term_id,
                                        ],
                                    ],
                                ];

                                // Check if "Post By" is set to "Selected"
                                if ( 'selected' === $settings['post_by'] ) {
                                    $query_args['post__in'] = (array) $settings['post__in'];
                                }

                                // Create the WP_Query
                                $args = new \WP_Query($query_args);

                            if ($args->have_posts()):
                                while ($args->have_posts()): $args->the_post(); ?>

                                    <div class="swiper-slide wow slideInDown" data-wow-delay=".3s" data-wow-duration="1s">
                                        <div class="td-portfolio-wrap">
                                            <?php if (has_post_thumbnail()): ?>
                                                <div class="td-portfolio-thumb mb-30">
                                                    <?php the_post_thumbnail('full'); ?>
                                                </div>
                                            <?php endif; ?>

                                            <div class="td-portfolio-cetagory">
                                                <?php
                                                $post_categories = get_the_terms(get_the_ID(), 'project_category');
                                                if (!empty($post_categories) && !is_wp_error($post_categories)):
                                                    $count = 0; // Initialize counter
                                                    foreach ($post_categories as $post_category):
                                                        if ($count >= 3) break; // Stop after displaying 3 categories
                                                        echo '<span><a href="' . esc_url(get_term_link($post_category)) . '">' . esc_html($post_category->name) . '</a></span>';
                                                        $count++; // Increment counter
                                                    endforeach;
                                                endif;
                                                ?>
                                            </div>

                                            <h3 class="td-portfolio-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h3>
                                        </div>
                                    </div>
                                <?php endwhile;
                                wp_reset_postdata();
                            endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>