<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-7">
            <div class="swiper-container td-portfolio-4-slider-active">
                <div class="swiper-wrapper">
                <?php 
                // Set up the query to fetch posts
                $number_of_post = !empty($settings['post_per_page']) ? $settings['post_per_page'] : -1;

                // Define the query arguments
                $query_args = [
                    'post_type'      => 'adina_project',
                    'order'          => $settings['order'],
                    'posts_per_page' => $number_of_post,
                    'post_status'    => 'publish',
                ];

                // Check if "Post By" is set to "Selected"
                if ( 'selected' === $settings['post_by'] ) {
                    $query_args['post__in'] = (array) $settings['post__in'];
                }

                // Create a new WP_Query
                $args = new \WP_Query($query_args);

                if ($args->have_posts()):
                    while ($args->have_posts()): $args->the_post(); ?>
                        <div class="swiper-slide">
                            <div class="td-portfolio-4-item">
                                <?php if (has_post_thumbnail()): ?>
                                    <div class="td-portfolio-4-thumb mb-40">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail('full'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <div class="td-portfolio-4-content">
                                    <div class="td-portfolio-4-tag">
                                        <?php
                                        $post_categories = get_the_terms(get_the_ID(), 'project_category');
                                        if (!empty($post_categories) && !is_wp_error($post_categories)):
                                            $count = 0; // Initialize counter
                                            foreach ($post_categories as $post_category):
                                                if ($count >= 3) break; // Stop after 3 categories
                                                echo '<a href="' . esc_url(get_term_link($post_category)) . '">' . esc_html($post_category->name) . '</a>';
                                                $count++; // Increment counter after each category
                                            endforeach;
                                        endif;
                                        ?>
                                    </div>
                                    <h4 class="td-portfolio-4-title">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h4>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; 
                    wp_reset_postdata();
                    endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>