<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Section Title Widget .
 *
 */
class Adina_Section_Title extends Widget_Base {

	public function get_name() {
		return 'section_title';
	}

	public function get_title() {
		return __( 'Section Title', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		// layout
        $this->start_controls_section('layout_section',
            [
                'label' => __('Layout', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();

		// Title content
		$this->start_controls_section(
			'title_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$this->add_control(
			'subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Life your Dream', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'title_layout' => 'layout-2',
                ]
			]
		);
		$this->add_control(
			'big_title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Secure your future family', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'title_layout' => 'layout-3',
                ]
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
				'condition' => [
                    'title_layout' => 'layout-3',
                ]
			]
		);
		$this->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Secure your future family', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'title_layout' => 'layout-2',
                ]
			]
		);
		$this->add_control(
			'title_paragraph',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Our focus is on delivering superior value to our clients for company modification. Providing sustainable strategies that will upgrade their business.', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'title_layout' => 'layout-2',
                ]
			]
		);
        $this->add_control(
			'first_title_text',
			[
				'label'   => esc_html__( 'First Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Achieve', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'title_layout' => 'layout-1',
                ]
			]
		);
        $this->add_control(
			'second_title_text',
			[
				'label'   => esc_html__( 'Second Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'results with', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'title_layout' => 'layout-1',
                ]
			]
		);
        $this->add_control(
			'third_title_text',
			[
				'label'   => esc_html__( 'Third Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'modern idea', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'title_layout' => 'layout-1',
                ]
			]
		);
        $this->add_responsive_control(
			'section_title_alignment',
			[
				'label'       => esc_html__( 'Title Alignment', 'adina' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'adina-text-align-left'   => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon'  => 'eicon-text-align-left'
					],
					'adina-text-align-center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon'  => 'eicon-text-align-left'
					],
					'adina-text-align-right'  => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon'  => 'eicon-text-align-left'
					]
				],
				'default'     => 'adina-text-align-left',
				'selectors_dictionary' => [
					'adina-text-align-left' => 'text-align: left;',
					'adina-text-align-center' => 'text-align: center;',
					'adina-text-align-right' => 'text-align: right;',
				],
				'selectors' => [
					'{{WRAPPER}} .td-hero-achive' => '{{VALUE}};',
					'{{WRAPPER}} .section-title-layout02' => '{{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		// SubTitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'title_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-achive-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-hero-2-title' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'color_title_color',
            [
                'label' => __( 'Span Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-2-title span' => 'color: {{VALUE}}',
                ],
				'condition' => [
                    'title_layout' => 'layout-3',
                ]
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'main_title_typography',
				'selector' => '{{WRAPPER}} .td-hero-achive-title, {{WRAPPER}} .td-section-title, {{WRAPPER}} .td-hero-2-title',
			]
		);		
        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-arrow-svg-top-right' => 'color: {{VALUE}}',
                ],
				'condition' => [
                    'title_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
            'border_color',
            [
                'label' => __( 'Border Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-achive-title .td-title-border::before' => 'background-color: {{VALUE}}',
                ],
				'condition' => [
                    'title_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_responsive_control(
			'border_width',
			[
				'label' => esc_html__( 'Border Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-hero-achive-title .td-title-border::before' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
                    'title_layout' => 'layout-1',
                ]
			]
		);
        $this->add_responsive_control(
			'border_height',
			[
				'label' => esc_html__( 'Border Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-hero-achive-title .td-title-border::before' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
                    'title_layout' => 'layout-1',
                ]
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-hero-2-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'condition' => [
                    'title_layout' => ['layout-2', 'layout-3']
                ]
            ]
        );
		$this->end_controls_section();

		// text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'title_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-about-para' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-about-para',
			]
		);
		$this->add_responsive_control(
            'text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-about-para' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $layout = $settings['title_layout'];

		?>
			<?php
                if ( $layout) {
                    include('section-title/'.$layout.'.php');
                }
            ?>  
		<?php
	}
}
$widgets_manager->register( new \Adina_Section_Title() );