<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Service Section Widget .
 *
 */
class Adina_Service_Section extends \Elementor\Widget_Base {

	public function get_name() {
		return 'adina_service_section';
	}

	public function get_title() {
		return esc_html__( 'Service Section', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'adina-addons' ];
	}

    protected function register_controls() {

        // Start Service Section
        $this->start_controls_section(
			'service_section',
			[
				'label' => esc_html__( 'Service Section', 'adina' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'service_shadow_title',
			[
				'label' => esc_html__( 'Shadow Title', 'adina' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default' => esc_html__( 'Services', 'adina' ),
			]
		);
        $this->add_control(
            'logo_image',
            [
                'label' => __('Logo Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'animation_image',
            [
                'label' => __('Animation Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'adina'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_services(),
            ]
        );
        $this->add_control(
            'service_lists',
            [
                'label' => __('Service Lists', 'adina'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
            
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-area' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-service-2-title',
			]
		);
		$this->add_control(
            'title_fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-2-title' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-2-title' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'title_stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-service-2-title' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-service-2-thumb img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-service-2-thumb img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Shadow Title style
        $this->start_controls_section(
            'shadow_title_style',
            [
                'label' => __( 'Shadow Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'shadow_title_typography',
				'selector' => '{{WRAPPER}} .td-transparent-title',
			]
		);
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'shadow_background',
                'label'    => __( 'Background', 'adina' ),
                'types'    => [ 'classic', 'gradient' ], // Only color and gradient
                'selector' => '{{WRAPPER}} .td-transparent-title',
            ]
        );
		$this->end_controls_section();


	}

    // Get All Services
    public function get_all_services() {

        $wp_query = get_posts([
            'post_type' => 'adina_service',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $services) {
            $options[$services->ID] = $services->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $service_lists = $settings['service_lists'];

        ?>
            <div class="td-service-area td-service-2-spacing fix td-grey-bg pt-140">
                <div class="container">
                    <div class="row">
                        <?php foreach( $service_lists as $item ) : 
                            $args = new \WP_Query(array(
                                'post_type' => 'adina_service',
                                'post_status' => 'publish',
                                'post__in' => [$item['select_post']]
                            )); 
                            ?>
                            <?php while ($args->have_posts()) : $args->the_post(); ?>
                                <div class="col-lg-12">
                                    <div class="td-service-2-content td-service-2-border scene p-relative wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                                    <h2 class="td-service-2-title">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h2>
                                    <?php if( has_post_thumbnail() ): ?>
                                        <div class="td-service-2-thumb">
                                            <?php the_post_thumbnail('full');?>
                                        </div>
                                    <?php endif; ?>
                                    </div>
                                </div>
                            <?php endwhile; wp_reset_postdata(); ?>
                        <?php endforeach; ?>

                        <div class="col-lg-12">
                            <div class="td-service-2-transparent text-center p-relative">
                            <h2 class="td-transparent-title" data-text="Services">
                                <?php echo esc_html( $settings[ 'service_shadow_title' ]  ); ?>
                            </h2>
                            <div class="td-service-2-sercile p-relative">
                                <img class="td-testimonial-qoute" src="<?php echo esc_url( $settings[ 'animation_image' ]['url'] ); ?>" alt="logo">
                                <img class="td-testimonial-qoute-2" src="<?php echo esc_url( $settings[ 'logo_image' ]['url'] ); ?>" alt="qoute">
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }

}

$widgets_manager->register( new \Adina_Service_Section() );