<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Service Widget .
 *
 */
class Adina_Service extends \Elementor\Widget_Base {

	public function get_name() {
		return 'adina_services';
	}

	public function get_title() {
		return esc_html__( 'Services', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'adina-addons' ];
	}

    protected function register_controls() {

        // Start Service Section
        $this->start_controls_section(
			'service_section',
			[
				'label' => esc_html__( 'Service Section', 'adina' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'service_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                    'layout-4' => esc_html__('Layout 4', 'adina'),
                    'layout-5' => esc_html__('Layout 5', 'adina'),
                    'layout-6' => esc_html__('Layout 6', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
			'show_section_title',
			[
				'label'        => __( 'Show Section Title', 'adina' ),
				'type'         =>   \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'adina' ),
				'label_off'    => __( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'      => 'yes',
                'condition' => [
                    'service_layout' => 'layout-4',
                ]
			]
		);
        $this->add_control(
			'subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Why Choose Us', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'service_layout' => 'layout-4',
                    'show_section_title' => 'yes',
                ]
			]
		);
		$this->add_control(
			'big_title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Learn about our financial services', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'service_layout' => 'layout-4',
                    'show_section_title' => 'yes',
                ]
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'adina'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_services(),
            ]
        );
        $repeater->add_control(
            'icon_image',
            [
                'label' => __('Icon', 'adina'),
                'type'  => Controls_Manager::MEDIA,
                'description' => 'For layout 3,4,5 & 6',
            ]
        );
        $repeater->add_control(
			'nmbr_text',
			[
				'label'   => esc_html__( 'Number', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '01', 'adina' ),
                'label_block' => true,
                'description' => 'For layout 1 & 2',
			]
		);
		$repeater->add_control(
			'category_text',
			[
				'label'   => esc_html__( 'Category', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Finance', 'adina' ),
                'label_block' => true,
                'description' => 'For layout 1',
			]
		);
        $repeater->add_control(
			'show_excerpt',
			[
				'label'        => __( 'Show Excerpt', 'adina' ),
				'type'         =>   \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'adina' ),
				'label_off'    => __( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
        $repeater->add_control(
			'show_btn',
			[
				'label'        => __( 'Show Button', 'adina' ),
				'type'         =>   \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'adina' ),
				'label_off'    => __( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'      => 'yes',
                'description' => 'For layout 1',
			]
		);
        $repeater->add_control(
			'service_btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default' => esc_html__( 'Read More', 'adina' ),
                'description' => 'For layout 1',
			]
		);
        $this->add_control(
            'service_lists',
            [
                'label' => __('Service Lists', 'adina'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
            
        );
		$this->end_controls_section();

        // SubTitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'service_layout' => 'layout-4',
                    'show_section_title' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Section Title style
        $this->start_controls_section(
            'sec_title_style',
            [
                'label' => __( 'Section Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'service_layout' => 'layout-4',
                    'show_section_title' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'sec_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sec_title_typography',
				'selector' => '{{WRAPPER}} .td-section-title',
			]
		);
		$this->add_responsive_control(
            'sec_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-chose-title-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Service Icon style
        $this->start_controls_section(
            'service_icon_style',
            [
                'label' => __( 'Service Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'service_layout' => ['layout-3', 'layout-4', 'layout-5', 'layout-6'],
                ]
            ]
        );
        $this->add_responsive_control(
			'service_icon_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-chose-icon img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-service-5-icon img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-service-6-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
            'service_icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-chose-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-5-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-6-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		// Number style
        $this->start_controls_section(
            'number_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => ['layout-1', 'layout-2'],
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .td-service-number, {{WRAPPER}} .td-service-3-number h2',
            ]
        );        
		$this->add_control(
            'number_fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-number' => '-webkit-text-fill-color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-3-number h2' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'number_hover_fill_color',
            [
                'label' => __( 'Hover Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-3-item:hover .td-service-3-number h2' => '-webkit-text-fill-color: {{VALUE}}',
                ],
                'condition' => [
                    'service_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_control(
            'number_stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-number' => '-webkit-text-stroke-color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-3-number h2' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'number_hover_stroke_color',
            [
                'label' => __( 'Hover Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-3-item:hover .td-service-3-number h2' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
                'condition' => [
                    'service_layout' => 'layout-2',
                ]
            ]
        );
		$this->add_responsive_control(
			'number_stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-service-number' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-service-3-number h2' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		// Category style
        $this->start_controls_section(
            'category_style',
            [
                'label' => __( 'Category', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
            'category_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-cetagory' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'category_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-cetagory' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .td-service-cetagory',
			]
		);
		$this->add_responsive_control(
            'category_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-cetagory' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		// Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-3-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-4-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-chose-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-5-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-6-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_Hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-3-item:hover .td-service-3-title' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'service_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .td-service-title, {{WRAPPER}} .td-service-3-title, {{WRAPPER}} .td-service-4-title, {{WRAPPER}} .td-chose-title, {{WRAPPER}} .td-service-6-title, {{WRAPPER}} .td-service-5-title', // Combined selectors
            ]
        );
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-3-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-4-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-chose-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-5-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-6-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		// Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-content-inner p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-3-para p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-4-content p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-chose-content p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-5-content p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-6-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .td-service-content-inner p, {{WRAPPER}} .td-service-3-para p, {{WRAPPER}} .td-service-4-content p, {{WRAPPER}} .td-chose-content p, {{WRAPPER}} .td-service-5-content p, {{WRAPPER}} .td-service-6-content p', // Combined selectors
            ]
        );        
		$this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-content-inner p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-3-para p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-4-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-chose-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-5-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-6-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		// Button style
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn, td-btn-2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn, td-btn-2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .td-btn, td-btn-2',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'btn_border',
				'selector' => '{{WRAPPER}} .td-btn, td-btn-2',
			]
		);
        $this->add_responsive_control(
			'btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-btn, td-btn-2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-btn, td-btn-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-arrow-svg-top-right' => 'fill: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => ['layout-2', 'layout-3', 'layout-6'],
                ]
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-3-item::before' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'service_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-service-3-item, {{WRAPPER}} .td-service-6-item',
                'condition' => [
                    'service_layout' => ['layout-2', 'layout-6'],
                ]
			]
		);
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-3-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-4-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-6-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-6-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'service_layout' => 'layout-6',
                ]
            ]
        );
		$this->end_controls_section();

	}

    // Get All Services
    public function get_all_services() {

        $wp_query = get_posts([
            'post_type' => 'adina_service',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $services) {
            $options[$services->ID] = $services->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $service_lists = $settings['service_lists'];
        $layout = $settings['service_layout'];

        ?>
			<?php
                if ( $layout) {
                    include('service/'.$layout.'.php');
                }
            ?> 
        <?php
    }

}

$widgets_manager->register( new \Adina_Service() );