<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Shape Widget .
 *
 */
class Adina_Shape extends Widget_Base {

	public function get_name() {
		return 'adina_shape';
	}

	public function get_title() {
		return __( 'Shape', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'shape_section',
			[
				'label' 	=> __( 'Shape', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_responsive_control(
			'shape_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-about-2-shape-2' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'shape_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-about-2-shape-2' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'shape_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-about-2-shape-2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <span class="td-about-2-shape-2 d-none d-lg-block"></span>
		<?php
	}
}
$widgets_manager->register( new \Adina_Shape() );