<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Slider Title Widget .
 *
 */
class Adina_Slider_Title extends Widget_Base {

	public function get_name() {
		return 'slider_title';
	}

	public function get_title() {
		return __( 'Slider Title', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'title_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Business', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title_slide',
			[
				'label' => __( 'Title', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-text-slider-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-hero-text-slider-title',
			]
		);
		$this->add_control(
            'fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-text-slider-title' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-text-slider-title' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-hero-text-slider-title' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		// Title Second style
        $this->start_controls_section(
            'title_second_style',
            [
                'label' => __( 'Second Item', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_second_typography',
				'selector' => '{{WRAPPER}} .swiper-slide:nth-of-type(even) .td-hero-text-slider-title',
			]
		);
		$this->add_control(
            'fill_second_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide:nth-of-type(even) .td-hero-text-slider-title' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'stroke_second_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide:nth-of-type(even) .td-hero-text-slider-title' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'stroke_second_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-slide:nth-of-type(even) .td-hero-text-slider-title' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="swiper-container td-hero-text-slider-active" data-sliderSpeed="400000" data-autoPlay="true">
                <div class="swiper-wrapper slide-transtion">
                    <?php foreach( $settings['title_slide'] as $title_slider ) : ?>
                        <div class="swiper-slide">
                            <div class="td-hero-text-slider-content text-center">
                                <h4 class="td-hero-text-slider-title"><?php echo esc_html( $title_slider[ 'title_text' ]  ); ?></h4>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Slider_Title() );