<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Svg Icon Widget .
 *
 */
class Adina_Svg_Icon extends Widget_Base {

	public function get_name() {
		return 'adina_svg_icon';
	}

	public function get_title() {
		return __( 'Adina Svg Icon', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
			<div class="svg-icon">
				<svg width="642" height="512" viewBox="0 0 642 512" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path opacity="0.15" d="M608.713 86.4H381.913V206.1C391.713 193.967 405.713 184.167 423.913 176.7C442.113 168.767 461.48 164.8 482.013 164.8C519.346 164.8 549.913 172.967 573.713 189.3C597.513 205.633 614.78 226.633 625.513 252.3C636.246 277.5 641.613 304.567 641.613 333.5C641.613 387.167 626.213 430.333 595.413 463C565.08 495.667 521.68 512 465.213 512C412.013 512 369.546 498.7 337.813 472.1C306.08 445.5 288.113 410.733 283.913 367.8H379.113C383.313 386.467 392.646 401.4 407.113 412.6C422.046 423.8 440.946 429.4 463.813 429.4C491.346 429.4 512.113 420.767 526.113 403.5C540.113 386.233 547.113 363.367 547.113 334.9C547.113 305.967 539.88 284.033 525.413 269.1C511.413 253.7 490.646 246 463.113 246C443.513 246 427.18 250.9 414.113 260.7C401.046 270.5 391.713 283.567 386.113 299.9H292.313V0.300049H608.713V86.4Z" fill="url(#paint0_linear_335_2111)" fill-opacity="0.5" />
					<path opacity="0.15" d="M0.200195 92V1.69995H168.9V512H68.1002V92H0.200195Z" fill="url(#paint1_linear_335_2111)" fill-opacity="0.5" />
					<defs>
					<linearGradient id="paint0_linear_335_2111" x1="327.5" y1="512" x2="327.5" y2="-4.49992" gradientUnits="userSpaceOnUse">
						<stop stop-color="white" offset="1" />
						<stop offset="1" stop-color="white" stop-opacity="0" />
					</linearGradient>
					<linearGradient id="paint1_linear_335_2111" x1="327.5" y1="512" x2="327.5" y2="-4.5" gradientUnits="userSpaceOnUse">
						<stop stop-color="white" offset="1" />
						<stop offset="1" stop-color="white" stop-opacity="0"/>
					</linearGradient>
					</defs>
				</svg>
			</div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Svg_Icon() );