<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Tab Two Widget .
 *
 */
class Adina_Tab_Two extends Widget_Base {

	public function get_name() {
		return 'adina_tab_two';
	}

	public function get_title() {
		return __( 'Adina Tab Two', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'tab_section',
			[
				'label' 	=> __( 'Tab Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $repeater = new Repeater();

        $repeater->add_control(
			'tab_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our Mission', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'tab_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'As a venture capital agency, we specialise in partnering with companies at various stages of their growth journey.', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'tab_img',
            [
                'label' => __('Tab Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'tab_item',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Tab Title style
        $this->start_controls_section(
            'tab_title_style',
            [
                'label' => __( 'Tab Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-details-tab .td-portfolio-tab-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_title_active_color',
            [
                'label' => __( 'Hover/Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-details-tab .td-portfolio-tab-btn:hover, .td-portfolio-details-tab .td-portfolio-tab-btn.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tagtab_title_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-details-tab .td-portfolio-tab-btn',
			]
		);
        $this->add_responsive_control(
            'tab_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-details-tab .td-portfolio-tab-btn-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Tab Text style
        $this->start_controls_section(
            'tab_text_style',
            [
                'label' => __( 'Tab Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-details-tab-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tagtab_text_typography',
				'selector' => '{{WRAPPER}} .td-portfolio-details-tab-content p',
			]
		);
        $this->add_responsive_control(
            'tab_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-portfolio-details-tab-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-portfolio-details-tab">
                <div class="nav td-portfolio-tab-btn-list " id="v-pills-tab" role="tablist" aria-orientation="vertical">
                    <?php foreach( $settings['tab_item'] as $index => $tab_item ) : ?>
                        <button class="td-portfolio-tab-btn nav-link mb-10 <?php echo $index === 0 ? 'active' : ''; ?>" id="v-pills-<?php echo $index+1; ?>-tab" data-bs-toggle="pill" data-bs-target="#v-pills-<?php echo $index+1; ?>" type="button" role="tab" aria-controls="v-pills-<?php echo $index+1; ?>" aria-selected="<?php echo $index === 0 ? 'true' : 'false'; ?>">
                            <?php echo esc_html( $tab_item['tab_title'] ); ?>               
                        </button>
                    <?php endforeach; ?>
                </div>
                <div class="td-banking-img-wrapper tab-content" id="v-pills-tabContent">
                    <?php foreach( $settings['tab_item'] as $index => $tab_item ) : ?>
                        <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>" id="v-pills-<?php echo $index+1; ?>" role="tabpanel" aria-labelledby="v-pills-<?php echo $index+1; ?>-tab">
                            <div class="td-portfolio-details-tab-content">
                                <p><?php echo esc_html( $tab_item['tab_text'] ); ?></p>
                                <div class="td-portfolio-details-tab-chart">
                                    <img class="w-100" src="<?php echo esc_url( $tab_item[ 'tab_img' ]['url'] ); ?>" alt="">
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Tab_Two() );