<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Tab Widget .
 *
 */
class Adina_Tab extends Widget_Base {

	public function get_name() {
		return 'adina_tab';
	}

	public function get_title() {
		return __( 'Adina Tab', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'tab_section',
			[
				'label' 	=> __( 'Tab Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
			'tab_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get a amazing solution with us.', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'link_text',
			[
				'label'   => esc_html__( 'Link Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get In Touch', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'text_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $repeater = new Repeater();

        $repeater->add_control(
			'tab_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Life Insurance', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'tab_icon',
			[
				'label'       => __( 'Title Icon', 'adina' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'tab_shortcode',
			[
				'label'   => esc_html__( 'Shortcode', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'tab_item',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-form-inner' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .td-hero-5-form-inner'
			]
		);
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-form-tab' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-form-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Tab Title style
        $this->start_controls_section(
            'tab_title_style',
            [
                'label' => __( 'Tab Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-tab-btn-list .td-hero-5-tab-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_title_active_color',
            [
                'label' => __( 'Hover/Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-tab-btn-list .td-hero-5-tab-btn:hover, .td-hero-5-tab-btn-list .td-hero-5-tab-btn.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tagtab_title_typography',
				'selector' => '{{WRAPPER}} .td-hero-5-tab-btn-list .td-hero-5-tab-btn',
			]
		);
        $this->add_responsive_control(
            'tab_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-tab-btn-list .td-hero-5-tab-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Tab Text style
        $this->start_controls_section(
            'tab_text_style',
            [
                'label' => __( 'Tab Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-tab-para P' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tagtab_text_typography',
				'selector' => '{{WRAPPER}} .td-hero-5-tab-para P',
			]
		);
		$this->end_controls_section();

        // Link Text style
        $this->start_controls_section(
            'link_text_style',
            [
                'label' => __( 'Link Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'link_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-5-tab-para P a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'link_text_typography',
				'selector' => '{{WRAPPER}} .td-hero-5-tab-para P a',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-hero-5-form-area">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-8 col-lg-10">
                            <div class="td-hero-5-form-inner">
                                <div class="td-hero-5-form-tab">
                                    <div class="nav td-hero-5-tab-btn-list td-portfolio-tab-btn-list justify-content-center" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                        <?php foreach( $settings['tab_item'] as $index => $tab_item ) : ?>
                                            <button class="td-hero-5-tab-btn mb-20 td-portfolio-tab-btn nav-link <?php echo $index === 0 ? 'active' : ''; ?>" id="v-pills-<?php echo $index+1; ?>-tab" data-bs-toggle="pill" data-bs-target="#v-pills-<?php echo $index+1; ?>" type="button" role="tab" aria-controls="v-pills-<?php echo $index+1; ?>" aria-selected="<?php echo $index === 0 ? 'true' : 'false'; ?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $tab_item['tab_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <?php echo esc_html( $tab_item['tab_title'] ); ?>
                                            </button>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="td-hero-5-tab-content d-flex justify-content-center tab-content" id="v-pills-tabContent">
                                        <?php foreach( $settings['tab_item'] as $index => $tab_item ) : ?>
                                            <div class="tab-pane fade <?php echo $index === 0 ? 'show active' : ''; ?>" id="v-pills-<?php echo $index+1; ?>" role="tabpanel" aria-labelledby="v-pills-<?php echo $index+1; ?>-tab">
                                                <?php echo do_shortcode($tab_item['tab_shortcode']); ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <div class="td-hero-5-tab-para">
                                    <p>
                                        <?php echo esc_html( $settings['tab_text'] ); ?>
                                        <a href="<?php echo esc_url($settings['text_link']['url']); ?>"> 
                                            <?php echo esc_html( $settings['link_text'] ); ?>
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Tab() );