<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Team Widget .
 *
 */
class Adina_Team_Member extends \Elementor\Widget_Base {

	public function get_name() {
		return 'adina_team_member';
	}

	public function get_title() {
		return esc_html__( 'Team', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
	}

	public function get_categories() {
		return [ 'adina-addons' ];
	}

    protected function register_controls() {

        $this->start_controls_section(
			'team_section',
			[
				'label' => esc_html__( 'Team', 'adina' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'team_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
			'show_section_title',
			[
				'label'        => __( 'Show Section Title', 'adina' ),
				'type'         =>   \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'adina' ),
				'label_off'    => __( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'      => 'yes',
                'condition' => [
                    'team_layout' => 'layout-2',
                ]
			]
		);
        $this->add_control(
			'subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Real Heros', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
			]
		);
		$this->add_control(
			'big_title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Meet the advisors', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'View More', 'adina' ),
                'label_block' => true,
                'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
			]
		);
        $this->add_control(
			'btn_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
                'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
			]
		);
        $this->add_control(
			'globe_icon_url_one',
			[
				'label' => __('Global Icon URL', 'adina'),
				'type' =>  \Elementor\Controls_Manager::URL,
                'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
			]
		);
        $this->add_control(
			'behance_icon_url_two',
			[
				'label' => __('Behance URL', 'adina'),
				'type' =>  \Elementor\Controls_Manager::URL,
                'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
			]
		);
        $repeater = new Repeater();

        $repeater->add_control(
            'select_post',
            [
                'label' => __('Must be Select a Post', 'adina'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'default' => 'none',
                'options' => $this->get_all_members(),
            ]
        );
        $repeater->add_control(
			'designation_text',
			[
				'label' => esc_html__( 'Designation', 'adina' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
				'default' => esc_html__( 'CEO & Founder', 'adina' ),
			]
		);
        $repeater->start_controls_tabs(
            'social_icons_tabs'
        );
        $repeater->start_controls_tab(
            'social_icons_tab',
            [
                'label' => __('Icons', 'adina'),
            ]
        );
        $repeater->add_control(
			'social_icon_one',
			[
				'label'       => __( 'Icon 01', 'adina' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_icon_two',
			[
				'label'       => __( 'Icon 02', 'adina' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_icon_three',
			[
				'label'       => __( 'Icon 03', 'adina' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_icon_four',
			[
				'label'       => __( 'Icon 04', 'adina' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_icon_five',
			[
				'label'       => __( 'Icon 05', 'adina' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            'social_linkss_tab',
            [
                'label' => __('URLs', 'adina'),
            ]
        );
        $repeater->add_control(
			'icon_url_one',
			[
				'label' => __('URL 01', 'adina'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'icon_url_two',
			[
				'label' => __('URL 02', 'adina'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'icon_url_three',
			[
				'label' => __('URL 03', 'adina'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'icon_url_four',
			[
				'label' => __('URL 04', 'adina'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'icon_url_five',
			[
				'label' => __('URL 05', 'adina'),
				'type' =>  \Elementor\Controls_Manager::URL,
			]
		);
        $repeater->end_controls_tab();
        $repeater->end_controls_tabs();

        $this->add_control(
            'team_lists',
            [
                'label' => __('Team Lists', 'adina'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();

        // SubTitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Section Title style
        $this->start_controls_section(
            'sec_title_style',
            [
                'label' => __( 'Section Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'sec_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sec_title_typography',
				'selector' => '{{WRAPPER}} .td-section-title',
			]
		);
		$this->add_responsive_control(
            'sec_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Button style
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .td-btn',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'btn_border',
				'selector' => '{{WRAPPER}} .td-btn',
			]
		);
        $this->add_responsive_control(
			'btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-arrow-svg-top-right' => 'fill: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Section Icon style
        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => __( 'Section Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'team_layout' => 'layout-2',
                    'show_section_title' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'section_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-4-top-social a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'section_icon_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-4-top-social a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'section_icon_bg_color',
            [
                'label' => __( 'Backrgound Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-4-top-social a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'section_icon_hover_bg_color',
            [
                'label' => __( 'Backrgound Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-4-top-social a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'section_icon_size',
			[
				'label' => esc_html__( 'Font Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-team-4-top-social a i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'section_icon_box_size',
			[
				'label' => esc_html__( 'Box Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-team-4-top-social a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'section_icon_border',
				'selector' => '{{WRAPPER}} .td-team-4-top-social a',
			]
		);
		$this->end_controls_section();

        // image style
        $this->start_controls_section(
            'image_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'team_layout' => 'layout-3',
                ]
            ]
        );
		$this->add_responsive_control(
            'image_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-team-5-thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'team_layout' => 'layout-3',
                ]
            ]
        );
		$this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-team-5-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Author Name style
        $this->start_controls_section(
            'author_name_style',
            [
                'label' => __( 'Author Name', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'author_name_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-4-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-5-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_name_typography',
				'selector' => '{{WRAPPER}} .td-team-title, {{WRAPPER}} .td-team-4-title, {{WRAPPER}} .td-team-5-title',
			]
		);
		$this->add_responsive_control(
            'author_name_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-team-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-team-4-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-team-5-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Designation style
        $this->start_controls_section(
            'designation_style',
            [
                'label' => __( 'Designation', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-designation' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-4-content span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-5-position' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'selector' => '{{WRAPPER}} .td-team-designation, {{WRAPPER}} .td-team-4-content span, {{WRAPPER}} .td-team-5-position',
			]
		);
		$this->end_controls_section();

        // icon style
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __( 'icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-social ul li a i, .td-team-4-social ul li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-social ul li a svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .td-team-5-social ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-wrapper:hover .td-team-social ul li:nth-child(1) a, .td-team-4-social ul li a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-social ul li a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-5-social ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __( 'Backrgound Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-social ul li a, .td-team-4-social ul li a' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'team_layout!' => 'layout-3',
                ]
            ]
        );
        $this->add_control(
            'icon_bg_hover_color',
            [
                'label' => __( 'Backrgound Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-team-wrapper:hover .td-team-social ul li:nth-child(1) a, .td-team-4-social ul li a:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-team-social ul li a:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'team_layout!' => 'layout-3',
                ]
            ]
        );
		$this->end_controls_section();


	}

    // Get All teams
    public function get_all_members() {

        $wp_query = get_posts([
            'post_type' => 'adina_team',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $teams) {
            $options[$teams->ID] = $teams->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $team_lists = $settings['team_lists'];
        $layout = $settings['team_layout'];

        ?>  
            <?php
                if ( $layout) {
                    include('team/'.$layout.'.php');
                }
            ?> 
        <?php
    }

}

$widgets_manager->register( new \Adina_Team_Member() );