<div class="row gx-0 align-items-center">
    <?php  foreach( $team_lists as $item ):
        $args = new \WP_Query(array(
            'post_type' => 'adina_team',
            'post_status' => 'publish',
            'post__in' => [
                $item['select_post']
            ]
        ));
        ?>
        <?php while ($args->have_posts()) : $args->the_post(); ?>
            <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInLeft" data-wow-delay=".3s" data-wow-duration="1s">
                <div class="td-team-4-item p-relative">
                    <?php if( has_post_thumbnail() ): ?>
                        <div class="td-team-4-thumb p-relative">
                            <?php the_post_thumbnail('full');?>
                            <span></span>
                        </div>
                    <?php endif; ?>

                    <div class="td-team-4-content">
                        <span><?php echo esc_html($item['designation_text']); ?></span>
                        <h4 class="td-team-4-title">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_title(); ?>
                            </a>
                        </h4>
                    </div>
                    <div class="td-team-4-social">
                        <span><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                        <ul>
                            <?php if ( ! empty( $item['social_icon_one']['value'] ) && ! empty( $item['icon_url_one']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_one']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_one'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_two']['value'] ) && ! empty( $item['icon_url_two']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_two']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_two'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_three']['value'] ) && ! empty( $item['icon_url_three']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_three']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_three'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_four']['value'] ) && ! empty( $item['icon_url_four']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_four']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_four'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_five']['value'] ) && ! empty( $item['icon_url_five']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_five']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_five'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endwhile; wp_reset_postdata(); ?>
    <?php endforeach; ?>

    <?php if ('yes' === $settings['show_section_title']) : ?>
        <div class="col-xl-6 col-lg-6 col-md-6 wow fadeInLeft" data-wow-delay=".5s" data-wow-duration="1s">
            <div class="td-team-4-title-wrap ml-120">
                <span class="td-section-title-pre mb-10">
                    <?php echo esc_html( $settings[ 'subtitle_text' ]  ); ?>
                </span>
                <h2 class="td-section-title mb-90">
                    <?php echo adina_kses( $settings[ 'big_title_text' ]  ); ?>
                </h2>
                <div class="td-team-4-btn-wrap d-flex align-items-center">
                    <div class="td-about-btn mr-20">
                        <a class="td-btn td-left-right" href="<?php echo esc_url($settings['btn_link']['url']); ?>">
                            <?php echo esc_html( $settings[ 'btn_text' ]  ); ?>
                            <span class="td-arrow-angle ml-10"> 
                            <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                                <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                            </svg> 
                            </span>
                        </a>
                    </div>
                    <div class="td-team-4-top-social">
                        <a href="<?php echo esc_url( $settings['globe_icon_url_one']['url'] ); ?>">
                            <i class="fa-sharp fa-regular fa-globe"></i>
                        </a>
                        <a href="<?php echo esc_url( $settings['behance_icon_url_two']['url'] ); ?>">
                            <i class="fa-brands fa-behance"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>