<div class="row">
<?php  foreach( $team_lists as $item ):
    $args = new \WP_Query(array(
        'post_type' => 'adina_team',
        'post_status' => 'publish',
        'post__in' => [
            $item['select_post']
        ]
    ));
    ?>
    <?php while ($args->have_posts()) : $args->the_post(); ?>
            <div class="col-xl-3 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                <div class="td-team-5-wrap mb-40">
                    <?php if( has_post_thumbnail() ): ?>
                        <div class="td-team-5-thumb mb-40">
                            <?php the_post_thumbnail('full');?>
                        </div>
                    <?php endif; ?>

                    <div class="td-team-5-content">
                        <h3 class="td-team-5-title"><a href="<?php the_permalink(); ?>">
                            <?php the_title(); ?>
                        </a>
                    </h3>
                        <span class="td-team-5-position">
                            <?php echo esc_html($item['designation_text']); ?>
                        </span>
                    </div>
                    <div class="td-team-5-social">
                        <span></span>
                        <ul>
                            <?php if ( ! empty( $item['social_icon_one']['value'] ) && ! empty( $item['icon_url_one']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_one']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_one'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_two']['value'] ) && ! empty( $item['icon_url_two']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_two']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_two'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_three']['value'] ) && ! empty( $item['icon_url_three']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_three']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_three'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_four']['value'] ) && ! empty( $item['icon_url_four']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_four']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_four'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if ( ! empty( $item['social_icon_five']['value'] ) && ! empty( $item['icon_url_five']['url'] ) ) : ?>
                                <li>
                                    <a href="<?php echo esc_url( $item['icon_url_five']['url'] ); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['social_icon_five'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endwhile; wp_reset_postdata(); ?>
    <?php endforeach; ?>
</div>