<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Testimonial Slider Section Two Widget .
 *
 */
class Adina_Testimonial_Slider_Section_Two extends Widget_Base {

	public function get_name() {
		return 'adina_testimonial_slider_section_two';
	}

	public function get_title() {
		return __( 'Testimonial Slider Section Two', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
			'subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Clients Thinking', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Testimonials', 'adina' ),
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        // slider section
        $this->start_controls_section(
			'slider_section',
			[
				'label' 	=> __( 'Slider Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
            'author_img',
            [
                'label' => __('Author Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'author_name',
			[
				'label'   => esc_html__( 'Author Name', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Monica Regan', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'author_designation',
			[
				'label'   => esc_html__( 'Designation', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'CEO, Regan Co', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'shape_img',
            [
                'label' => __('Author Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'testimonial_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '“Our focus is on delivering superior value to our clients for company modification. Providing sustainable strategies that will upgrade their business. From strategy to delivery, we are here to make sure your business succeeds.”', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			't_slide_content',
			[
				'label' => __( 'Slider Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // SubTitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-section-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Arrow style
        $this->start_controls_section(
            'arrow_style',
            [
                'label' => __( 'Arrow', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-4-btn-inner div' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-4-btn-inner div:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-4-btn-inner div' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_hover_bg_color',
            [
                'label' => __( 'Hover Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-4-btn-inner div:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'arrow_size',
			[
				'label' => esc_html__( 'Font Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-testimonial-4-btn-inner i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-4-btn-inner div' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Author Name style
        $this->start_controls_section(
            'author_name_style',
            [
                'label' => __( 'Author Name', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'author_name_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-avater-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_name_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-avater-title',
			]
		);
		$this->add_responsive_control(
            'author_name_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-avater-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Designation style
        $this->start_controls_section(
            'designation_style',
            [
                'label' => __( 'Designation', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-avater-designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-avater-designation',
			]
		);
		$this->end_controls_section();

        // Testimonial Text style
        $this->start_controls_section(
            'Testimonial_text_style',
            [
                'label' => __( 'Testimonial Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            't_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-4-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 't_text_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-4-content p',
			]
		);
        $this->add_responsive_control(
            't_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-4-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-testimonial-4-border',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-testimonial-area">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-8 col-md-7">
                            <div class="td-testimonial-title-wrap mb-80">
                                <span class="td-section-title-pre td-white mb-10"><?php echo esc_html( $settings[ 'subtitle_text' ]  ); ?></span>
                                <h2 class="td-section-title td-white"><?php echo esc_html( $settings[ 'title_text' ]  ); ?></h2>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-5">
                            <div class="td-testimonial-4-btn d-flex justify-content-end">
                                <div class="td-testimonial-4-btn-inner">
                                <div class="td-testimonial-4-prev"><i class="fa-sharp fa-regular fa-arrow-left"></i></div>
                                <div class="td-testimonial-4-next"><i class="fa-sharp fa-regular fa-arrow-right"></i></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="td-testimonial-4-border pb-100">
                                <div class="swiper-container td-testimonial-4-slider-active">
                                    <div class="swiper-wrapper">
                                        <?php foreach( $settings['t_slide_content'] as $slider_content ) : ?>
                                            <div class="swiper-slide">
                                                <div class="row">
                                                    <div class="col-lg-3 col-md-3">
                                                    <div class="td-testimonial-avater">
                                                        <div class="td-testimonial-avater-thumb mb-40">
                                                            <img src="<?php echo esc_url($slider_content['author_img']['url']); ?>" alt="thumb">
                                                        </div>
                                                        <div class="td-testimonial-avater-info">
                                                            <h5 class="td-testimonial-avater-title"><?php echo esc_html( $slider_content[ 'author_name' ]  ); ?></h5>
                                                            <span class="td-testimonial-avater-designation"><?php echo esc_html( $slider_content[ 'author_designation' ]  ); ?></span>
                                                        </div>
                                                    </div>
                                                    </div>
                                                    <div class="col-lg-9 col-md-9">
                                                    <div class="td-testimonial-4-content">
                                                        <span></span>
                                                        <img class="mb-40 d-none d-md-block" src="<?php echo esc_url($slider_content['shape_img']['url']); ?>" alt="pattern">
                                                        <p><?php echo esc_html( $slider_content[ 'testimonial_text' ]  ); ?></p>
                                                    </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Testimonial_Slider_Section_Two() );