<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Testimonial Slider Section Widget .
 *
 */
class Adina_Testimonial_Slider_Section extends Widget_Base {

	public function get_name() {
		return 'adina_testimonial_slider_section';
	}

	public function get_title() {
		return __( 'Testimonial Slider Section', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
			'first_title_text',
			[
				'label'   => esc_html__( 'First Slider Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Amazing Experience /', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'second_title_text',
			[
				'label'   => esc_html__( 'Second Slider Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Amazing Design', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
            'quote_image',
            [
                'label' => __('Quote Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Testimonials', 'adina' ),
                'label_block' => true,
			]
		);
		$this->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our client says', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
            'quote_02_image',
            [
                'label' => __('Quote 02 Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'video_img',
            [
                'label' => __('Video Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'video_url',
			[
				'label' => __( 'Video URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
		$this->end_controls_section();

        // slider section
        $this->start_controls_section(
			'slider_section',
			[
				'label' 	=> __( 'Slider Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
			'testimonial_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '“Our focus is on delivering superior value to our clients for company modification. Providing sustainable strategies that will upgrade their business. From strategy to delivery, we are here to make sure.”', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'author_img',
            [
                'label' => __('Author Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'author_name',
			[
				'label'   => esc_html__( 'Author Name', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Monica Regan', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'author_designation',
			[
				'label'   => esc_html__( 'Designation', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'CEO, Monica Co.', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			't_slide_content',
			[
				'label' => __( 'Slider Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // First Title style
        $this->start_controls_section(
            'first_title_style',
            [
                'label' => __( 'First Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'first_title_fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-slider-title-tr' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'first_title_Stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-slider-title-tr' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'first_title_title_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-slider-title-tr',
			]
		);
        $this->add_responsive_control(
			'first_title_stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-testimonial-slider-title-tr' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Second Title style
        $this->start_controls_section(
            'second_title_style',
            [
                'label' => __( 'Second Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'second_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-slider-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'second_title_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-slider-title',
			]
		);
		$this->end_controls_section();

        // SubTitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-section-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-title-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
        
        // Video Icon style
        $this->start_controls_section(
            'video_icon_style',
            [
                'label' => __( 'Video Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'video_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-play' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'video_icon_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-play' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Slider Text style
        $this->start_controls_section(
            'Slider_text_style',
            [
                'label' => __( 'Slider Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'slider_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-slider p' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'slider_text_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-2-slider p',
			]
		);
		$this->add_responsive_control(
            'slider_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-slider p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Author Name style
        $this->start_controls_section(
            'author_name_style',
            [
                'label' => __( 'Author Name', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'author_name_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-avater-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_name_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-2-avater-title',
			]
		);
		$this->add_responsive_control(
            'author_name_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-avater-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Designation style
        $this->start_controls_section(
            'designation_style',
            [
                'label' => __( 'Designation', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-avater-designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-2-avater-designation',
			]
		);
		$this->end_controls_section();

        // Slider Box style
        $this->start_controls_section(
            'slider_box_style',
            [
                'label' => __( 'Slider Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'slider_box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-slider-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'slider_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-slider-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

         // Box style
         $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-bottom' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-testimonial-area fix">
                <div class="container-fluid g-0">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="td-testimonial-text-slider">
                                <div class="swiper-container td-hero-text-slider-active" data-sliderSpeed="400000" data-autoPlay="true">
                                    <div class="swiper-wrapper slide-transtion">
                                        <div class="swiper-slide">
                                            <div class="td-hero-text-slider-content text-center">
                                                <h4 class="td-testimonial-slider-title-tr"><?php echo esc_html( $settings[ 'first_title_text' ]  ); ?></h4>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="td-hero-text-slider-content text-center">
                                                <h4 class="td-testimonial-slider-title"><?php echo esc_html( $settings[ 'second_title_text' ]  ); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="td-testimonial-2-bottom td-black-bg">
                                <img class="td-testimonial-2-qoute" src="<?php echo esc_url($settings['quote_image']['url']); ?>" alt="qoute">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="td-testimonial-2-content td-testimonial-2-space">
                                            <div class="td-testimonial-title-wrap p-relative mb-75">
                                                <span class="td-section-title-pre td-gray mb-10"><?php echo esc_html( $settings[ 'subtitle_text' ]  ); ?></span>
                                                <h2 class="td-section-title td-white"><?php echo adina_kses( $settings[ 'title_text' ]  ); ?></h2>
                                            </div>
                                            <div class="td-testimonial-2-slider-wrap p-relative">
                                                <img class="td-testimonial-2-qoute-2 d-none d-sm-block" src="<?php echo esc_url($settings['quote_02_image']['url']); ?>" alt="qoute">
                                                <div class="swiper-container td-testimonial-2-slide-active">
                                                    <div class="swiper-wrapper">
                                                        <?php foreach( $settings['t_slide_content'] as $slider_content ) : ?>
                                                            <div class="swiper-slide">
                                                                <div class="td-testimonial-2-slider">
                                                                    <p><?php echo esc_html( $slider_content[ 'testimonial_text' ]  ); ?></p>
                                                                    <div class="td-testimonial-2-avater d-flex align-items-center">
                                                                    <div class="td-testimonial-2-avater-thumb">
                                                                        <img src="<?php echo esc_url($slider_content['author_img']['url']); ?>" alt="user">
                                                                    </div>
                                                                    <div class="td-testimonial-2-avater-info">
                                                                        <h3 class="td-testimonial-2-avater-title"><?php echo esc_html( $slider_content[ 'author_name' ]  ); ?></h3>
                                                                        <span class="td-testimonial-2-avater-designation"><?php echo esc_html( $slider_content[ 'author_designation' ]  ); ?></span>
                                                                    </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="td-testimonial-2-thumb p-relative">
                                            <img class="w-100" src="<?php echo esc_url($settings['video_img']['url']); ?>" alt="">
                                            <div class="td-testimonial-video">
                                                <a class="td-video-play popup-video td-pulse-border" href="<?php echo esc_url($settings['video_url']['url']); ?>">
                                                    <span class="p-relative z-index-11">
                                                        <svg width="14" height="20" viewBox="0 0 14 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M14 10L0 20V0L14 10Z" fill="currentColor" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Testimonial_Slider_Section() );