<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Testimonial Slider Two Widget .
 *
 */
class Adina_Testimonial_Slider_Two extends Widget_Base {

	public function get_name() {
		return 'adina_testimonial_slider_two';
	}

	public function get_title() {
		return __( 'Testimonial Slider Two', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_section',
			[
				'label' 	=> __( 'Testimonial', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'testimonial_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
			'slider_para',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Bring them together and you overcome  the ordinary.', 'adina' ),
                'label_block' => true,
                'condition' => [
                    'testimonial_layout' => 'layout-2',
                ]
			]
		);
        $this->add_control(
			'link_text',
			[
				'label'   => esc_html__( 'Link Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'See what we do.', 'adina' ),
                'label_block' => true,
                'condition' => [
                    'testimonial_layout' => 'layout-2',
                ]
			]
		);
        $this->add_control(
			'text_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
                'condition' => [
                    'testimonial_layout' => 'layout-2',
                ]
			]
		);
		$repeater = new Repeater();

        $repeater->add_control(
			'rating_text',
			[
				'label'   => esc_html__( 'Rating Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '1k+ good ratings', 'adina' ),
                'label_block' => true,
                'description' => 'For layout 1',
			]
		);
        $repeater->add_control(
			'testimonial_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Providing sustainable strategies that will upgrade their business. From strategy to delivery, we are here to make sure your business succeeds. Thinking, writing and planning with brand for more than 50 years.', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'author_img',
            [
                'label' => __('Author Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'author_name',
			[
				'label'   => esc_html__( 'Author Name', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Emila Parker', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'author_designation',
			[
				'label'   => esc_html__( 'Designation', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'CEO, Exbrox', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			't_slider_content',
			[
				'label' => __( 'Slider Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Logo Slider
        $this->start_controls_section(
			'logo_section',
			[
				'label' 	=> __( 'Logo', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$logo_repeater = new Repeater();

        $logo_repeater->add_control(
            'logo_img',
            [
                'label' => __('Logo Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $logo_repeater->add_control(
			'logo_url',
			[
				'label' => __( 'Logo URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'logo_slider_content',
			[
				'label' => __( 'Logo Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $logo_repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Testimonial Box style
        $this->start_controls_section(
            'testimonial_box_style',
            [
                'label' => __( 'Testimonial Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            't_box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-content' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-testimonial-5-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            't_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-testimonial-5-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 't_box_shadow',
				'selector' => '{{WRAPPER}} .td-testimonial-3-wrap, {{WRAPPER}} .td-testimonial-5-wrap'
			]
		);
		$this->end_controls_section();

        // Arrow style
        $this->start_controls_section(
            'arrow_style',
            [
                'label' => __( 'Arrow', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'testimonial_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'arrow_shadow',
				'selector' => '{{WRAPPER}} .td-testimonial-3-btn div'
			]
		);
        $this->add_responsive_control(
			'arrow_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-testimonial-3-btn div' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-btn div' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-btn div' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'arrow_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-testimonial-3-btn div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

        // Rating style
        $this->start_controls_section(
            'rating_style',
            [
                'label' => __( 'Rating', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'testimonial_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
            'rating_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-ratngs i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'rating_size',
			[
				'label' => esc_html__( 'Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-testimonial-3-ratngs i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'rating_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-ratngs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Rating Text style
        $this->start_controls_section(
            'rating_text_style',
            [
                'label' => __( 'Rating Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'testimonial_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
            'rating_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-ratngs span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'rating_text_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-3-ratngs span',
			]
		);
		$this->end_controls_section();

        // Testimonial Text style
        $this->start_controls_section(
            'Testimonial_text_style',
            [
                'label' => __( 'Testimonial Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            't_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-content p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-testimonial-5-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 't_text_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-3-content p, {{WRAPPER}} .td-testimonial-5-content p',
			]
		);
        $this->add_responsive_control(
            't_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-testimonial-5-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Author Name style
        $this->start_controls_section(
            'author_name_style',
            [
                'label' => __( 'Author Name', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'author_name_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-avater-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-testimonial-5-avatar-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_name_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-3-avater-title, {{WRAPPER}} .td-testimonial-5-avatar-title',
			]
		);
		$this->add_responsive_control(
            'author_name_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-avater-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-testimonial-5-avatar-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Designation style
        $this->start_controls_section(
            'designation_style',
            [
                'label' => __( 'Designation', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-2-avater-designation' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-testimonial-5-avatar-designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-2-avater-designation, {{WRAPPER}} .td-testimonial-5-avatar-designation',
			]
		);
		$this->end_controls_section();

        // Logo Box style
        $this->start_controls_section(
            'logo_box_style',
            [
                'label' => __( 'Logo Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'logo_box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-profile' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-testimonial-5-brands' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-3-profile' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-testimonial-5-brands' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'logo_box_border',
				'selector' => '{{WRAPPER}} .td-testimonial-3-profile, {{WRAPPER}} .td-testimonial-5-brands',
			]
		);
		$this->end_controls_section();

        // slider_para Text style
        $this->start_controls_section(
            'slider_para_text_style',
            [
                'label' => __( 'Slider Para Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'testimonial_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_control(
            'slider_para_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-5-slider-para p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'slider_para_text_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-5-slider-para p',
			]
		);
        $this->add_control(
            'slider_para_link_text_color',
            [
                'label' => __( 'Link Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-5-slider-para p a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'slider_para_link_text_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-5-slider-para p a',
			]
		);
        $this->add_responsive_control(
            'slider_para_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-5-slider-para' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
		$layout = $settings['testimonial_layout'];

		?>
            <?php
                if ( $layout) {
                    include('t-slider-two/'.$layout.'.php');
                }
            ?> 
		<?php
	}
}
$widgets_manager->register( new \Adina_Testimonial_Slider_Two() );