<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Adina_Testimonial_Slider extends Widget_Base {

	public function get_name() {
		return 'adina_testimonial_slider';
	}

	public function get_title() {
		return __( 'Adina Testimonial Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'rotate_image',
            [
                'label' => __('Rotate Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'quote_image',
            [
                'label' => __('Quote Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'shadow_text',
			[
				'label'   => esc_html__( 'Shadow Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Feedback', 'adina' ),
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        // slider item
        $this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Slider Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
			't_name',
			[
				'label'   => esc_html__( 'Name', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Sarah N. Newman', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			't_designation',
			[
				'label'   => esc_html__( 'Name', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Founder, Newman', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			't_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '“Our focus is on delivering superior value to our clients for company modification.', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            't_image',
            [
                'label' => __('Auhtor Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			't_slide_content',
			[
				'label' => __( 'Slider Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Name style
        $this->start_controls_section(
            'name_style',
            [
                'label' => __( 'Name', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-avatar-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-avatar-title',
			]
		);
		$this->add_responsive_control(
            'name_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-avatar-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Designation style
        $this->start_controls_section(
            'designation_style',
            [
                'label' => __( 'Designation', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-avatar-designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-avatar-designation',
			]
		);
		$this->add_responsive_control(
            'designation_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-avatar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-testimonial-content p',
			]
		);
		$this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-testimonial-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-testimonial-area p-relative">
                <div class="td-testimonial-qoute-wrap">
                    <div class="td-testimonial-qoute-thumb p-relative">
                        <img class="td-testimonial-qoute" src="<?php echo esc_url($settings['rotate_image']['url']); ?>" alt="logo">
                        <img class="td-testimonial-qoute-2" src="<?php echo esc_url($settings['quote_image']['url']); ?>" alt="qoute">
                    </div>
                </div>
                <div class="container-fluid d-none d-md-block">
                    <div class="col-12">
                        <div class="td-testimonial-bg-text text-center">
                            <h2><?php echo esc_html( $settings[ 'shadow_text' ]  ); ?></h2>
                        </div>
                    </div>
                </div>
                <div class="td-testimonial-main td-testimonial-transparet">
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-xxl-12">
                                <div class="testimonial__slider-9 p-relative">
                                    <div class="row justify-content-center">
                                        <div class="col-xxl-6 col-xl-7 col-lg-7">
                                            <div class="testimonial__slider-active-9">
                                                <?php foreach( $settings['t_slide_content'] as $slider_content ) : ?>
                                                    <div class="testimonial__item-9">
                                                        <div class="td-testimonial-content text-center">
                                                            <div class="td-testimonial-avatar mb-35">
                                                                <h4 class="td-testimonial-avatar-title m-0"><?php echo esc_html( $slider_content[ 't_name' ]  ); ?></h4>
                                                                <span class="td-testimonial-avatar-designation"><?php echo esc_html( $slider_content[ 't_designation' ]  ); ?></span>
                                                            </div>
                                                            <p><?php echo esc_html( $slider_content[ 't_text' ]  ); ?></p>
                                                        </div>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row justify-content-center">
                                        <div class="col-xxl-7 col-xl-6 col-lg-7 col-md-10 col-sm-10">
                                            <div class="testimonial__slider-nav-9 ml-15 mr-15 pt-30">
                                                <?php foreach( $settings['t_slide_content'] as $slider_content ) : ?>
                                                    <div class="testimonial__slider-9-thumb-nav">
                                                        <div class="tp-border-loader">
                                                            <svg width="116" height="116" viewBox="0 0 116 116" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <circle cx="58" cy="58" r="56.5" stroke-width="0"></circle> 
                                                                <circle cx="58" cy="58" r="56.5" stroke-width="3" stroke-linecap="round" style="stroke-dashoffset: -356px; stroke-dasharray: 0px, 366px;"></circle>
                                                            </svg>
                                                        </div>
                                                        <img src="<?php echo esc_url($slider_content['t_image']['url']); ?>" alt="">
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Testimonial_Slider() );