<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Video Box Widget .
 *
 */
class Adina_Video_Box extends Widget_Base {

	public function get_name() {
		return 'video_box';
	}

	public function get_title() {
		return __( 'Video Box', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'video_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                    'layout-4' => esc_html__('Layout 4', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
            'video_image',
            [
                'label' => __('Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'video_url',
			[
				'label' => __( 'Video URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'first_title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get amazing', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'video_layout' => ['layout-2', 'layout-3', 'layout-4'],
                ]
			]
		);
        $this->add_control(
			'second_title_text',
			[
				'label'   => esc_html__( 'Second Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'experience', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'video_layout' => 'layout-2',
                ]
			]
		);
        $this->add_control(
			'third_title_text',
			[
				'label'   => esc_html__( 'Third Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'with us', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'video_layout' => 'layout-2',
                ]
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Find your solutions', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'video_layout' => 'layout-4',
                ]
			]
		);
        $this->add_control(
			'video_link',
			[
				'label' => __( 'Contact Link', 'adina' ),
				'type' => Controls_Manager::URL,
                'condition' => [
                    'video_layout' => ['layout-2', 'layout-4'],
                ]
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'video_layout' => ['layout-1', 'layout-4', 'layout-2'],
                ]
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-hero-3-video-thumb',
                'condition' => [
                    'video_layout' => 'layout-1',
                ]
			]
		);
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'video_box_shadow',
				'selector' => '{{WRAPPER}} .td-hero-3-video-thumb',
                'condition' => [
                    'video_layout' => 'layout-1',
                ]
			]
		);
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-video-5-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-video-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'video_layout' => ['layout-4', 'layout-2'],
                ]
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style03_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'video_layout' => 'layout-3',
                ]
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_style03_typography',
				'selector' => '{{WRAPPER}} .td-video-4-big-title',
			]
		);
		$this->add_control(
            'title_style03_fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-4-big-title' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_style03_Stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-4-big-title' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'title_style03_stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-video-4-big-title' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'video_layout' => ['layout-2', 'layout-4'],
                ]
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-5-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-video-title, {{WRAPPER}} .td-video-5-title',
			]
		);
        $this->add_control(
            'border_color',
            [
                'label' => __( 'Border Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-title-border::after' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'video_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_responsive_control(
			'border_width',
			[
				'label' => esc_html__( 'Border Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-video-title-border::after' => 'width: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'video_layout' => 'layout-2',
                ]
			]
		);
        $this->add_responsive_control(
			'border_height',
			[
				'label' => esc_html__( 'Border Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-video-title-border::after' => 'height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'video_layout' => 'layout-2',
                ]
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-video-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-video-5-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Play Button style
        $this->start_controls_section(
            'play_btn_style',
            [
                'label' => __( 'Play Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'play_btn_Size',
			[
				'label' => esc_html__( 'Button Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-video-play' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'play_btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-3-video-play' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-play' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-5-play' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'play_btn_Hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-3-video-play:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-play:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-5-play:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'play_btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-3-video-play' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-play' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-5-play' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'play_btn_hover_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-3-video-play:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-play:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-video-5-play:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Button style
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'video_layout' => 'layout-4',
                ]
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn-7' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn-7' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .td-btn',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'btn_border',
				'selector' => '{{WRAPPER}} .td-btn',
			]
		);
        $this->add_responsive_control(
			'btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-video-5-btn .td-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-arrow-svg-top-right' => 'fill: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $layout = $settings['video_layout'];

		?>
            <?php
                if ( $layout) {
                    include('video/'.$layout.'.php');
                }
            ?> 
		<?php
	}
}
$widgets_manager->register( new \Adina_Video_Box() );