<?php
/**
 * Plugin Name: Adina Core
 * Description: This is a helper plugin of adina theme
 * Version:     1.0.1
 * Author:      Themedox
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: adina
 */
 // Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit();
}

// Define Constant
define( 'ADINA_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'ADINA_PLUGIN_INC_PATH', plugin_dir_path( __FILE__ ) . 'inc/' );
define( 'ADINA_PLUGIN_CMB2EXT_PATH', plugin_dir_path( __FILE__ ) . 'cmb2-ext/' );
define( 'ADINA_PLUGIN_WIDGET_PATH', plugin_dir_path( __FILE__ ) . 'inc/widgets/' );
define( 'ADINA_PLUGIN_MODULES_PATH', plugin_dir_path( __FILE__ ) . 'inc/modules/' );
define( 'ADINA_PLUGDIRURI', plugin_dir_url( __FILE__ ) );
define( 'ADINA_ADDONS', plugin_dir_path( __FILE__ ) .'addons/' );
define( 'ADINA_CORE_PLUGIN_TEMP', plugin_dir_path( __FILE__ ) .'adina-template/' );

// load textdomain
load_plugin_textdomain( 'adina', false, basename( dirname( __FILE__ ) ) . '/languages' );

//include file.
require_once ADINA_PLUGIN_INC_PATH .'adinacore-functions.php';
require_once ADINA_PLUGIN_INC_PATH .'custom-post-types.php';
require_once ADINA_PLUGIN_INC_PATH .'helper-functions.php';
require_once ADINA_PLUGIN_INC_PATH . 'MCAPI.class.php';
require_once ADINA_PLUGIN_INC_PATH .'adinaajax.php';
require_once ADINA_PLUGIN_INC_PATH .'builder/builder.php';

require_once ADINA_PLUGIN_CMB2EXT_PATH . 'cmb2ext-init.php';

//Widget
require_once ADINA_PLUGIN_WIDGET_PATH . 'recent-post-widget.php';
require_once ADINA_PLUGIN_WIDGET_PATH . 'social-widget.php';
require_once ADINA_PLUGIN_WIDGET_PATH . 'about-us-widget.php';
require_once ADINA_PLUGIN_WIDGET_PATH . 'about-me-widget.php';
require_once ADINA_PLUGIN_WIDGET_PATH . 'newsletter-widget.php';
require_once ADINA_PLUGIN_WIDGET_PATH . 'gallery-widget.php';
require_once ADINA_PLUGIN_WIDGET_PATH . 'event-widget.php';
require_once ADINA_PLUGIN_WIDGET_PATH . 'video-box-widget.php';

require_once ADINA_PLUGIN_MODULES_PATH . 'custom-css.php';

//addons
require_once ADINA_ADDONS . 'addons.php';