(function ($) {

    "use strict";


    /*---------- Global Js ----------*/
    var Global_Js = function ($scope) {
        // 13. button hover animation
        $('.td-btn-rounded').on('mouseenter', function (e) {
            var x = e.pageX - $(this).offset().left;
            var y = e.pageY - $(this).offset().top;

            $(this).find('.td-btn-circle-dot').css({
                top: y,
                left: x
            });
        });
    }


    // Mobile Menu
    var mobile_menu_Js = function ($scope) {
        if ($('.td-main-menu-content').length && $('.td-main-menu-mobile').length) {
            // Get main menu content and insert into mobile menu
            let navContent = document.querySelector(".td-main-menu-content").outerHTML;
            let mobileNavContainer = document.querySelector(".td-main-menu-mobile");
            mobileNavContainer.innerHTML = navContent;
        
            // Select all dropdown menu items
            let dropdownLinks = $(".td-main-menu-mobile .menu-item-has-children > a");
        
            dropdownLinks.each(function() {
                let self = $(this);
        
                // Prevent the anchor default action and handle dropdown toggle
                self.on("click", function(e) {
                    e.preventDefault(); // Prevent link navigation
        
                    let parentItem = self.parent(); // Get parent .menu-item-has-children
                    let subMenu = parentItem.children(".sub-menu");
        
                    // Toggle open/close states
                    subMenu.slideToggle();
                    parentItem.toggleClass("expanded");
        
                    // Close other open dropdowns
                    parentItem.siblings(".menu-item-has-children").removeClass("expanded").find(".sub-menu").slideUp();
                });
            });
        }
        // 09. Sidebar Js
        $(".td-menu-bar").on("click", function () {
            $(".tdoffcanvas").addClass("opened");
            $(".body-overlay").addClass("apply");
        });
        $(".close-btn").on("click", function () {
            $(".tdoffcanvas").removeClass("opened");
            $(".body-overlay").removeClass("apply");
        });
        $(".body-overlay").on("click", function () {
            $(".tdoffcanvas").removeClass("opened");
            $(".body-overlay").removeClass("apply");
        });
    }

    // Slider Title Js
    var Slider_Title_Js = function ($scope) {
        var text_slider_option = document.querySelector(".td-hero-text-slider-active");

        if (text_slider_option) {

            var text_slider_speed = 2000000
            var text_slider_autoplay = true
            var loop_value = true
            var data_itemshow = "auto"

            if (text_slider_option.getAttribute("data-sliderSpeed")) {
                text_slider_speed = parseInt(text_slider_option.getAttribute("data-sliderSpeed"));
            }
            if (text_slider_option.getAttribute("data-autoPlay")) {
                text_slider_autoplay = text_slider_option.getAttribute("data-autoPlay")
            }

            if (text_slider_option.getAttribute("data-loop")) {
                loop_value = text_slider_option.getAttribute("data-loop")
            }
            if (text_slider_option.getAttribute("data-itemShow")) {
                data_itemshow = text_slider_option.getAttribute("data-itemShow")
            }


            if (text_slider_autoplay == 'true') {
                var text_slider = new Swiper(".td-hero-text-slider-active", {
                    loop: loop_value,
                    speed: text_slider_speed,
                    allowTouchMove: false,
                    slidesPerView: data_itemshow,
                    slidesPerGroup: 10,
                    spaceBetween: 50,
                    autoplay: {
                        delay: 0,
                        disableOnInteraction: true,
                    }
                });
            }
            else {
                var text_slider = new Swiper(".td-hero-text-slider-active", {
                    loop: loop_value,
                    speed: text_slider_speed,
                    allowTouchMove: false,
                    slidesPerView: data_itemshow,
                    slidesPerGroup: 10,
                    spaceBetween: 20,
                    autoplay: false,
                });

            }
        };
    }


    // Video Popup Js
    var Video_Popup_Js = function ($scope) {
        $(".popup-video").magnificPopup({
            type: "iframe",
        });
    }

    // Testimonial Slider Js
    var Testimonial_Slider_Js = function ($scope) {
        if ($(".testimonial__slider-active-9").length > 0) {
            $('.testimonial__slider-active-9').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: false,
                fade: true,
                centerMode: false,
                cssEase: 'linear',
                asNavFor: '.testimonial__slider-nav-9',
            });
        }
    
        if ($(".testimonial__slider-nav-9").length > 0) {
            $('.testimonial__slider-nav-9').slick({
                slidesToShow: 7,
                slidesToScroll: 1,
                asNavFor: '.testimonial__slider-active-9',
                dots: false,
                centerMode: false,
                focusOnSelect: true,
                autoplay: false,
                speed: 100,
                autoplaySpeed: 8000,
                cssEase: 'linear',
                loop: true,
                appendArrows: false,
                responsive: [
                    {
                        breakpoint: 1400,
                        settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 992,
                        settings: {
                        slidesToShow: 4,
                        slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 768,
                        settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 576,
                        settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 420,
                        settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                        },
                    },
                    {
                        breakpoint: 0,
                        settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        },
                    },
                ],
            });
        }
    }


    // Logo Slider Js
    var Logo_Slider_Js = function ($scope) {
        var slider = new Swiper('.td-brand-slide', {
            spaceBetween: 60,
            loop: true,
            freeMode: true,
            slidesPerView: 'auto',
            autoplay: {
            delay: 4000,
            },
            breakpoints: {
                '768': {
                    spaceBetween: 30,
                },
                '576': {
                    spaceBetween: 20,
                },
                '0': {
                    spaceBetween: 20,
                },
            },
        });
    }


    // Progress bar Js
    var Progress_Bar_Js = function ($scope) {
        $("[data-width]").each(function () {
            $(this).css("width", $(this).attr("data-width"));
        });
    }
    

    // Counter Js
    var Counter_Js = function ($scope) {
        new PureCounter();
        new PureCounter({
            filesizing: true,
            selector: ".filesizecount",
            pulse: 2,
        });
    }


    // Testimonial Section Js
    var Testimonial_Section_Js = function ($scope) {
        // Slider title
        var text_slider_option = document.querySelector(".td-hero-text-slider-active");

        if (text_slider_option) {

            var text_slider_speed = 2000000
            var text_slider_autoplay = true
            var loop_value = true
            var data_itemshow = "auto"

            if (text_slider_option.getAttribute("data-sliderSpeed")) {
                text_slider_speed = parseInt(text_slider_option.getAttribute("data-sliderSpeed"));
            }
            if (text_slider_option.getAttribute("data-autoPlay")) {
                text_slider_autoplay = text_slider_option.getAttribute("data-autoPlay")
            }

            if (text_slider_option.getAttribute("data-loop")) {
                loop_value = text_slider_option.getAttribute("data-loop")
            }
            if (text_slider_option.getAttribute("data-itemShow")) {
                data_itemshow = text_slider_option.getAttribute("data-itemShow")
            }


            if (text_slider_autoplay == 'true') {
                var text_slider = new Swiper(".td-hero-text-slider-active", {
                    loop: loop_value,
                    speed: text_slider_speed,
                    allowTouchMove: false,
                    slidesPerView: data_itemshow,
                    slidesPerGroup: 10,
                    spaceBetween: 50,
                    autoplay: {
                        delay: 0,
                        disableOnInteraction: true,
                    }
                });
            }
            else {
                var text_slider = new Swiper(".td-hero-text-slider-active", {
                    loop: loop_value,
                    speed: text_slider_speed,
                    allowTouchMove: false,
                    slidesPerView: data_itemshow,
                    slidesPerGroup: 10,
                    spaceBetween: 20,
                    autoplay: false,
                });

            }
        };

        // testimonial slider
        var slider = new Swiper('.td-testimonial-2-slide-active', {
            spaceBetween: 60,
            loop: true,
            slidesPerView: 'auto',
            autoplay: {
            delay: 4000,
            },
        });

        // Video Popup
        $(".popup-video").magnificPopup({
            type: "iframe",
        });
    }


    // accordion Js
    var Accordion_Js = function ($scope) {
        $('.td-faq-wrapper .accordion-item').on("click", function(){
            $(this).addClass('td-faq-active').siblings().removeClass('td-faq-active');
        }); 
    }


    // Testimonial Slider Two Js
    var Testimonial_Slider_Two_Js = function ($scope) {
        // Testimonial slider js
        var swiper = new Swiper(".td-testimonial-3-slider-active", {
            slidesPerView: 1,
            speed:1000,
            spaceBetween: 20,
            loop: true,
            effect: 'fade',
            a11y: false,
            navigation: {
                prevEl: '.td-testimonial-prev',
                nextEl: '.td-testimonial-next',
            },
        });

        // logo slider js
        var slider = new Swiper('.td-testimonial-profile-slide', {
            spaceBetween: 100,
            loop: true,
            freeMode: true,
            slidesPerView: 'auto',
            autoplay: {
            delay: 4000,
            },
            breakpoints: {
                '768': {
                    spaceBetween: 70,
                },
                '576': {
                    spaceBetween: 20,
                },
                '0': {
                    spaceBetween: 20,
                },
            },
        });

        // Testimonial slider layout 2 js
        var slider = new Swiper('.td-testimonial-5-slider-active', {
            spaceBetween: 30,
            loop: true,
            speed: 3000,
            autoplay: {
              delay: 3000, 
            },
            breakpoints: {
                '1200': {
                    slidesPerView: 2,
                },
                '991': {
                    slidesPerView: 1,
                },
                '768': {
                    slidesPerView: 1,
                },
                '576': {
                    slidesPerView: 1,
                },
                '0': {
                    slidesPerView: 1,
                },
            },
        });

        // logo slider layout 2 js
        var slider = new Swiper('.td-testimonial-profile-slide', {
            spaceBetween: 100,
            loop: true,
            freeMode: true,
            slidesPerView: 'auto',
            autoplay: {
            delay: 4000,
            },
            breakpoints: {
                '768': {
                    spaceBetween: 70,
                },
                '576': {
                    spaceBetween: 20,
                },
                '0': {
                    spaceBetween: 20,
                },
            },
        });
    }
    // Testimonial slider Two Js end


    // Testimonial Section Two Js
    var Testimonial_Section_Two_Js = function ($scope) {
        var swiper = new Swiper(".td-testimonial-4-slider-active", {
            slidesPerView: 1,
            speed:1000,
            spaceBetween: 20,
            loop: true,
            a11y: false,
            navigation: {
                prevEl: '.td-testimonial-4-prev',
                nextEl: '.td-testimonial-4-next',
            },
        });
    }

    // About Js
    var About_Js = function ($scope) {
        function mediaSize() { 
            if (window.matchMedia('(min-width: 768px)').matches) {
                const panels = document.querySelectorAll('.col-custom')
                panels.forEach(panel => {
                    panel.addEventListener('click', () => {
                        removeActiveClasses()
                        panel.classList.add('active')
                    })
                })
                function removeActiveClasses() {
                    panels.forEach(panel => {
                        panel.classList.remove('active')
                    })
                }
            } else {
            /* Reset for CSS changes – Still need a better way to do this! */
                $(".col-custom ").addClass("active");
            }
        };
        mediaSize();
        window.addEventListener('resize', mediaSize, false); 
    }

    // Service Js
    var Service_Js = function ($scope) {
        $('.service__item-8').on("mouseenter", function(){
            $(this).addClass('active').siblings().removeClass('active');
            $('#service-bg-img').removeClass().addClass($(this).attr('rel'));
        }); 
    }

    // Project Slider Js
    var Project_Slider_Js = function ($scope) {
        // Project Slider One JS
        var swiper = new Swiper(".td-portfolio-slider-active", {
            slidesPerView: 1,
            speed:1500,
            spaceBetween: 60,
            loop: true,
            freeMode: true,
            observer: true,
            observeParents: true,
            breakpoints: {
                '1200': {
                    slidesPerView: 3,
                },
                '991': {
                    slidesPerView: 3,
                    spaceBetween: 40,
                },
                '768': {
                    slidesPerView: 2,
                    spaceBetween: 30,
                },
                '576': {
                    slidesPerView: 1,
                    spaceBetween: 30,
                },
                '0': {
                    slidesPerView: 1,
                    spaceBetween: 30,
                },
            },
        });

        // Filter js
        const tabs = document.querySelectorAll('.td-portfolio-tab-btn');
        const tabContent = document.querySelectorAll('.tab-pane');

        tabs.forEach(tab => {
            tab.addEventListener('click', function () {
                const targetId = this.getAttribute('data-bs-target');

                // Hide all tab content
                tabContent.forEach(content => {
                    content.classList.remove('show', 'active');
                });

                // Show the targeted tab content
                document.querySelector(targetId).classList.add('show', 'active');
            });
        });

        // Project Slider Two JS
        var slider = new Swiper('.td-portfolio-4-slider-active', {
            slidesPerView: 1,
            spaceBetween: 80,
            loop: true,
            speed: 3000,
            autoplay: {
              delay: 3000, 
            },
            breakpoints: {
                '992': {
                    spaceBetween: 60,
                },
                '768': {
                    spaceBetween: 40,
                },
                '576': {
                    spaceBetween: 30,
                },
                '0': {
                    spaceBetween: 20,
                },
            },
        });
    }


    // Blog Slider Js
    var Blog_Slider_Js = function ($scope) {
        var swiper = new Swiper(".td-blog-slider-active", {
            slidesPerView: 1,
            speed:1500,
            spaceBetween: 60,
            loop: true,
            freeMode: true,
            breakpoints: {
                '1400': {
                    slidesPerView: 4,
                },
                '1200': {
                    slidesPerView: 3,
                },
                '991': {
                    slidesPerView: 3,
                    spaceBetween: 40,
                },
                '768': {
                    slidesPerView: 2,
                    spaceBetween: 30,
                },
                '576': {
                    slidesPerView: 2,
                    spaceBetween: 30,
                },
                '0': {
                    slidesPerView: 1,
                    spaceBetween: 30,
                },
            },
        });
    }


    // Hero Slider Js
    var Hero_Slider_Js = function ($scope) {
        if ($(".td-hero-4-nav-active").length > 0) {
            var slidernav = new Swiper(".td-hero-4-nav-active", {
                spaceBetween: 0,
                slidesPerView: 1,
                loop: true,
                freeMode: false,
                watchSlidesProgress: true,
                effect: 'fade',
                allowTouchMove: false,
                navigation: {
                    nextEl: ".slider-8-button-next",
                    prevEl: ".slider-8-button-prev",
                },
                breakpoints: {
                    '576': {
                        slidesPerView: 1,
                    },
                    '0': {
                        slidesPerView: 1,
                    },
                },
            });
        }
    
        if ($(".td-hero-4-slider-active").length > 0) {
            let sliderActive1 = ".td-hero-4-slider-active";
            let sliderInit1 = new Swiper(sliderActive1, {
                slidesPerView: 1,
                slidesPerColumn: 1,
                paginationClickable: true,
                loop: true,
                effect: 'fade',
    
                // If we need pagination
                pagination: {
                    el: ".main-slider-dot, .td-hero-4-dot",
                    clickable: true,
                    renderBullet: function (index, className) {
                      return '<span class="' + className + '">' + '<button>'+ '0' +(  index + 1)+'</button>' + "</span>";
                    },
                },
    
                // Navigation arrows
                navigation: {
                    prevEl: ".td-hero-4-navigation-next, .slider-button-8-next",
                    nextEl: ".td-hero-4-navigation-prev, .slider-button-8-prev",
                },
    
                a11y: false,
                thumbs: {
                    swiper: slidernav,
                },
            });
    
            function animated_swiper(selector, init) {
                let animated = function animated() {
                    $(selector + " [data-animation]").each(function () {
                        let anim = $(this).data("animation");
                        let delay = $(this).data("delay");
                        let duration = $(this).data("duration");
    
                        $(this)
                            .removeClass("anim" + anim)
                            .addClass(anim + " animated")
                            .css({
                                webkitAnimationDelay: delay,
                                animationDelay: delay,
                                webkitAnimationDuration: duration,
                                animationDuration: duration,
                            })
                            .one(
                                "webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend",
                                function () {
                                    $(this).removeClass(anim + " animated");
                                }
                            );
                    });
                };
                animated();
                // Make animated when slide change
                init.on("slideChange", function () {
                    $(sliderActive1 + " [data-animation]").removeClass("animated");
                });
                init.on("slideChange", animated);
            }
    
            animated_swiper(sliderActive1, sliderInit1);
        }
    }

    // Accordion Section Js
    var Accordion_Section_Js = function ($scope) {
        $('.td-faq-wrapper .accordion-item').on("click", function(){
            $(this).addClass('td-faq-active').siblings().removeClass('td-faq-active');
        }); 
    }

    // Image Slider Js
    var Image_Slider_Js = function ($scope) {
        var swiper = new Swiper(".td-about-slider-active", {
            slidesPerView: 1,
            speed:1500,
            spaceBetween: 80,
            loop: true,
            freeMode: true,
            observer: true,
            observeParents: true,
            breakpoints: {
                '1200': {
                    slidesPerView: 3,
                },
                '991': {
                    slidesPerView: 3,
                    spaceBetween: 40,
                },
                '768': {
                    slidesPerView: 2,
                    spaceBetween: 30,
                },
                '576': {
                    slidesPerView: 1,
                    spaceBetween: 30,
                },
                '0': {
                    slidesPerView: 1,
                    spaceBetween: 30,
                },
            },
        });
    }

    // History JS
    var History_Js = function ($scope) {
        $('#section-time').onePageNav({
            currentClass: 'current',
            scrollSpeed: 950,
        });
    }

    // circlebar JS
    var Circlebar_Js = function ($scope) {
        $scope.find('.knob').each(function() {
            $(this).knob({
                'readOnly': true,
                'change': function(value) {
                    $(this).val(value).trigger('change');
                }
            });
        });
    }


    $(window).on("elementor/frontend/init", function () {

        elementorFrontend.hooks.addAction("frontend/element_ready/adina_header.default", mobile_menu_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/slider_title.default", Slider_Title_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/video_box.default", Video_Popup_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_testimonial_slider.default", Testimonial_Slider_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_Logo_slider.default", Logo_Slider_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/progress_bar.default", Progress_Bar_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_Brand_Logo.default", Counter_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_testimonial_slider_section.default", Testimonial_Section_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_accordion.default", Accordion_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_testimonial_slider_two.default", Testimonial_Slider_Two_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/global", Global_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_testimonial_slider_section_two.default", Testimonial_Section_Two_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_about.default", About_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_services.default", Service_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_project_slider.default", Project_Slider_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_blog_slider.default", Blog_Slider_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_hero_slider.default", Hero_Slider_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_accordion_section.default", Accordion_Section_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_image_slider.default", Image_Slider_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/adina_history_section.default", History_Js);
        elementorFrontend.hooks.addAction("frontend/element_ready/progress_bar.default", Circlebar_Js);

    });

})(jQuery);

