<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function adina_core_essential_scripts( ) {
    wp_enqueue_script('adina-ajax',ADINA_PLUGDIRURI.'assets/js/adina.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'adina-ajax',
    'adinaajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'adina-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','adina_core_essential_scripts');


// adina Section subscribe ajax callback function
add_action( 'wp_ajax_adina_subscribe_ajax', 'adina_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_adina_subscribe_ajax', 'adina_subscribe_ajax' );

function adina_subscribe_ajax( ){
  $apiKey = adina_opt('adina_subscribe_apikey');
  $listid = adina_opt('adina_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'adina-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'adina').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);

           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'adina').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'adina').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'adina').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'adina').'</div>';
        }
   }

   wp_die();

}