<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

/**
 * Single Template
 */
add_filter( 'single_template', 'adina_core_template_redirect' );

if( ! function_exists( 'adina_core_template_redirect' ) ){
    function adina_core_template_redirect( $single_template ){

        global $post;

        // teacher Single Page
        if( $post ){
            if( $post->post_type == 'adina_teacher' ){
                $single_template = ADINA_CORE_PLUGIN_TEMP . 'single-adina_teacher.php';
            }
        }

        if( $post ){
            if( $post->post_type == 'adina_class' ){
                $single_template = ADINA_CORE_PLUGIN_TEMP . 'single-adina_class.php';
            }
        }

        if( $post ){
            if( $post->post_type == 'adina_event' ){
                $single_template = ADINA_CORE_PLUGIN_TEMP . 'single-adina_event.php';
            }
        }

        return $single_template;
    }
}


/**
 * Archive Template
 */
add_filter( 'archive_template', 'adina_core_template_archive' );

if( ! function_exists( 'adina_core_template_archive' ) ){
    function adina_core_template_archive( $archive_template ){

        global $post;

        // Service Archive Template
        if( $post ){
            if( $post->post_type == 'adina_class' ){
                $archive_template = ADINA_CORE_PLUGIN_TEMP . 'archive-adina_class.php';
            }
        }

        return $archive_template;
    }
}


/**
 * Meta Output
 *
 * @since 1.0
 *
 * @return array
 */
if ( ! function_exists( 'adina_get_meta' ) ) {
  function adina_get_meta( $data ) {
      global $wp_embed;
      $adina_content = $wp_embed->autoembed( $data );
      $adina_content = $wp_embed->run_shortcode( $adina_content );
      $adina_content = do_shortcode( $adina_content );
      $adina_content = wpautop( $adina_content );
      return $adina_content;
  }
}


/**
 * Admin Custom Login Logo
 */
function adina_custom_login_logo() {
  $logo = ! empty( adina_opt( 'adina_admin_login_logo', 'url' ) ) ? adina_opt( 'adina_admin_login_logo', 'url' ) : '' ;
  if( isset( $logo ) && !empty( $logo ) )
      echo '<style type="text/css">body.login div#login h1 a { background-image:url('.esc_url( $logo ).'); }</style>';
}
add_action( 'login_enqueue_scripts', 'adina_custom_login_logo' );

/**
* Admin Custom css
*/
add_action( 'admin_enqueue_scripts', 'adina_admin_styles' );

function adina_admin_styles() {
  // $adina_admin_custom_css = ! empty( adina_opt( 'adina_theme_admin_custom_css' ) ) ? adina_opt( 'adina_theme_admin_custom_css' ) : '';
  if ( ! empty( $adina_admin_custom_css ) ) {
      $adina_admin_custom_css = str_replace(array("\r\n", "\r", "\n", "\t", '    '), '', $adina_admin_custom_css);
      echo '<style rel="stylesheet" id="adina-admin-custom-css" >';
              echo esc_html( $adina_admin_custom_css );
      echo '</style>';
  }
}

// Social Icons
if ( ! function_exists( 'adina_icon_list_options' ) ) {
    function adina_icon_list_options() {
        $socialIcons = array(
            'facebook-f' => 'Facebook',
            'twitter' => 'Twitter',
            'instagram' => 'Instagram',
            'linkedin' => 'LinkedIn',
            'pinterest-p' => 'Pinterest',
            'youtube' => 'Youtube',
            'github' => 'GitHub',
            'google' => 'Google',
            // Add more social icons as needed
        );
        return $socialIcons;
    }
}


 // share button code
 function adina_social_sharing_buttons( ) {

  // Get page URL
  $URL = get_permalink();
  $Sitetitle = get_bloginfo('name');

  // Get page title
  $Title = str_replace( ' ', '%20', get_the_title());


  // Construct sharing URL without using any script

  $twitterURL = 'https://twitter.com/share?text='.esc_html( $Title ).'&url='.esc_url( $URL );
  $facebookURL = 'https://www.facebook.com/sharer/sharer.php?u='.esc_url( $URL );
  $pinteresturl = 'http://pinterest.com/pin/create/link/?url='.esc_url( $URL ).'&media='.esc_url(get_the_post_thumbnail_url()).'&description='.wp_kses_post(get_the_title());
  $linkedin = 'https://www.linkedin.com/shareArticle?mini=true&url='.esc_url( $URL ).'&title='.esc_html( $Title );


  // Add sharing button at the end of page/page content
$content = '';

  $content .= '<a class="facebook" href="'.esc_url( $facebookURL ).'" target="_blank"><span class="fab fa-facebook"></span></a>';
  $content .= '<a class="twitter" href="'. esc_url( $twitterURL ) .'" target="_blank"><span class="fab fa-twitter"></span></a>';
  $content .= '<a class="instagram" href="'.esc_url( $pinteresturl ).'" target="_blank"><span class="fab fa-pinterest"></span></a>';
  $content .= '<a class="linkedin" href="'.esc_url( $linkedin ).'" target="_blank"><span class="fab fa-linkedin"></span></a>';
  return $content;
};

//add SVG to allowed file uploads
function adina_mime_types( $mimes ) {
  $mimes['svg'] = 'image/svg+xml';
  $mimes['svgz'] = 'image/svgz+xml';
  $mimes['exe'] = 'program/exe';
  $mimes['dwg'] = 'image/vnd.dwg';
  return $mimes;
}
add_filter('upload_mimes', 'adina_mime_types');

function adina_wp_check_filetype_and_ext( $data, $file, $filename, $mimes ) {
    $wp_filetype = wp_check_filetype( $filename, $mimes );
    $ext         = $wp_filetype['ext'];
    $type        = $wp_filetype['type'];
    $proper_filename = $data['proper_filename'];

    return compact( 'ext', 'type', 'proper_filename' );
}
add_filter('wp_check_filetype_and_ext','adina_wp_check_filetype_and_ext',10,4);

if( ! function_exists('adina_get_user_role_name') ){
    function adina_get_user_role_name( $user_ID ){
        global $wp_roles;

        $user_data      = get_userdata( $user_ID );
        $user_role_slug = $user_data->roles[0];
        return translate_user_role( $wp_roles->roles[$user_role_slug]['name'] );
    }
}


add_filter('wpcf7_autop_or_not', '__return_false');
add_image_size( 'blog-sidebar-size',100,100,true );
add_image_size( 'home-slider-blog-image',387,320,true );
add_image_size( 'home-slider-blog-image-one',290,260,true );
add_image_size( 'home-slider-blog-image-three',387,250,true );
add_image_size( 'home-slider-blog-image-four',314,228,true );
add_image_size( 'home-slider-blog-image-five',370,424,true );
add_image_size( 'adina-related-post-size',270,314,true );
add_image_size( 'adina-class-post',360,306,true );
add_image_size( 'adina-class-post-two',230,230,true );



/**
* Enqueue block editor JavaScript and CSS
*/
function adina_widget_editor_scripts() {

  // Make paths variables so we don't write em twice 
  // $blockPath = '../assets/js/blocks.js';

  
  // Enqueue the bundled block JS file
  wp_enqueue_script(
      'adina-blocks-js', ADINA_PLUGDIRURI . 'assets/js/blocks.js',
      [  'wp-blocks', 'wp-element', 'wp-components', 'wp-i18n' ],
      '1.00',
      true
  );
}
// Hook scripts function into block editor hook
add_action( 'enqueue_block_editor_assets', 'adina_widget_editor_scripts' );




/**
 * Post Category
 */
if( ! function_exists( 'adina_events_category' ) ){
  function adina_events_category(){
      $cat_array = array();
      $cat_array[] = esc_html__( 'Select a category','adina' );
      $terms = get_terms( array(
          'taxonomy'      => 'event_category',
          'hide_empty'    => true
      ) );
      if( is_array( $terms ) && $terms ){
          foreach( $terms as $term ){
              $cat_array[$term->slug] = $term->name;
          }
      }
      return $cat_array;
  }
}

/**
 * Get Posts
 *
 * @since 1.0
 *
 * @return array
 */
if ( ! function_exists( 'adina_get_all_posts' ) ) {
    function adina_get_all_posts($posttype)
    {
        $args = array(
            'post_type' => $posttype,
            'post_status' => 'publish',
            'posts_per_page' => -1
        );

        $post_list = array();
        if( $data = get_posts($args)){
            foreach($data as $key){
                $post_list[$key->ID] = $key->post_title;
            }
        }
        return  $post_list;
    }
}


/**
 * Responsive Column Order
 *
 */
function adina_add_responsive_column_order( $element, $args ) {
	$element->add_responsive_control(
		'responsive_column_order',
		[
			'label' => __( 'Responsive Column Order', 'adina' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'separator' => 'before',
			'selectors' => [
				'{{WRAPPER}}' => '-webkit-order: {{VALUE}}; -ms-flex-order: {{VALUE}}; order: {{VALUE}};',
			],
		]
	);
}
add_action( 'elementor/element/column/layout/before_section_end', 'adina_add_responsive_column_order', 10, 2 );
