<?php
    /**
     * Class For Builder
     */
    class AdinaBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'adina_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'adina-core',ADINA_PLUGDIRURI.'assets/js/adina-core.js',array( 'jquery' ),'1.0',true );
		}


        public function adina_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'adina_header_option',
                [
                    'label'     => __( 'Header Option', 'adina' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'adina_header_style',
                [
                    'label'     => __( 'Header Option', 'adina' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'adina' ),
    					'header_builder'       => __( 'Header Builder', 'adina' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'adina_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'adina' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->adina_header_choose_option(),
                    'condition' => [ 'adina_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'adina_footer_option',
                [
                    'label'     => __( 'Footer Option', 'adina' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'adina_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'adina' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'adina' ),
    				'label_off'     => __( 'No', 'adina' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'adina_footer_style',
                [
                    'label'     => __( 'Footer Style', 'adina' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'adina' ),
    					'footer_builder'       => __( 'Footer Builder', 'adina' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'adina_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'adina_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'adina' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->adina_footer_choose_option(),
                    'condition' => [ 'adina_footer_style' => 'footer_builder','adina_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Adina Builder', 'adina' ),
            	esc_html__( 'Adina Builder', 'adina' ),
				'manage_options',
				'adina',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('adina', esc_html__('Footer Builder', 'adina'), esc_html__('Footer Builder', 'adina'), 'manage_options', 'edit.php?post_type=adina_footer');
			add_submenu_page('adina', esc_html__('Header Builder', 'adina'), esc_html__('Header Builder', 'adina'), 'manage_options', 'edit.php?post_type=adina_header');
			add_submenu_page('adina', esc_html__('Tab Builder', 'adina'), esc_html__('Tab Builder', 'adina'), 'manage_options', 'edit.php?post_type=adina_tab_build');
			add_submenu_page('adina', esc_html__('OFF Canvas Builder', 'adina'), esc_html__('OFF Canvas Builder', 'adina'), 'manage_options', 'edit.php?post_type=adina_off_build');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','adina' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'adina' ),
				'singular_name'      => __( 'Footer', 'adina' ),
				'menu_name'          => __( 'Adina Footer Builder', 'adina' ),
				'name_admin_bar'     => __( 'Footer', 'adina' ),
				'add_new'            => __( 'Add New', 'adina' ),
				'add_new_item'       => __( 'Add New Footer', 'adina' ),
				'new_item'           => __( 'New Footer', 'adina' ),
				'edit_item'          => __( 'Edit Footer', 'adina' ),
				'view_item'          => __( 'View Footer', 'adina' ),
				'all_items'          => __( 'All Footer', 'adina' ),
				'search_items'       => __( 'Search Footer', 'adina' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'adina' ),
				'not_found'          => __( 'No Footer found.', 'adina' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'adina' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'adina_footer', $args );

			$labels = array(
				'name'               => __( 'Header', 'adina' ),
				'singular_name'      => __( 'Header', 'adina' ),
				'menu_name'          => __( 'Adina Header Builder', 'adina' ),
				'name_admin_bar'     => __( 'Header', 'adina' ),
				'add_new'            => __( 'Add New', 'adina' ),
				'add_new_item'       => __( 'Add New Header', 'adina' ),
				'new_item'           => __( 'New Header', 'adina' ),
				'edit_item'          => __( 'Edit Header', 'adina' ),
				'view_item'          => __( 'View Header', 'adina' ),
				'all_items'          => __( 'All Header', 'adina' ),
				'search_items'       => __( 'Search Header', 'adina' ),
				'parent_item_colon'  => __( 'Parent Header:', 'adina' ),
				'not_found'          => __( 'No Header found.', 'adina' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'adina' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'adina_header', $args );

            $labels = array(
				'name'               => __( 'Tab Builder', 'adina' ),
				'singular_name'      => __( 'Tab Builder', 'adina' ),
				'menu_name'          => __( 'Adina Tab Builder', 'adina' ),
				'name_admin_bar'     => __( 'Tab Builder', 'adina' ),
				'add_new'            => __( 'Add New', 'adina' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'adina' ),
				'new_item'           => __( 'New Tab Builder', 'adina' ),
				'edit_item'          => __( 'Edit Tab Builder', 'adina' ),
				'view_item'          => __( 'View Tab Builder', 'adina' ),
				'all_items'          => __( 'All Tab Builder', 'adina' ),
				'search_items'       => __( 'Search Tab Builder', 'adina' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'adina' ),
				'not_found'          => __( 'No Tab Builder found.', 'adina' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'adina' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);
			register_post_type( 'adina_tab_build', $args );

			//Off Canvas builder
            $labels = array(
				'name'               => __( 'Off Canvas Builder', 'adina' ),
				'singular_name'      => __( 'Off Canvas Builder', 'adina' ),
				'menu_name'          => __( 'Adina Off Canvas Builder', 'adina' ),
				'name_admin_bar'     => __( 'Off Canvas Builder', 'adina' ),
				'add_new'            => __( 'Add New', 'adina' ),
				'add_new_item'       => __( 'Add New Off Canvas Builder', 'adina' ),
				'new_item'           => __( 'New Off Canvas Builder', 'adina' ),
				'edit_item'          => __( 'Edit Off Canvas Builder', 'adina' ),
				'view_item'          => __( 'View Off Canvas Builder', 'adina' ),
				'all_items'          => __( 'All Off Canvas Builder', 'adina' ),
				'search_items'       => __( 'Search Off Canvas Builder', 'adina' ),
				'parent_item_colon'  => __( 'Parent Off Canvas Builder:', 'adina' ),
				'not_found'          => __( 'No Off Canvas Builder found.', 'adina' ),
				'not_found_in_trash' => __( 'No Off Canvas Builder found in Trash.', 'adina' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);
			register_post_type( 'adina_off_build', $args );

		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'adina_footer' == $post->post_type || 'adina_header' == $post->post_type || 'adina_tab_build' == $post->post_type || 'adina_off_build' == $post->post_type  ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function adina_footer_choose_option(){

			$adina_post_query = new WP_Query( array(
				'post_type'			=> 'adina_footer',
				'posts_per_page'	    => -1,
			) );

			$adina_builder_post_title = array();
			$adina_builder_post_title[''] = __('Select a Footer','Adina');

			while( $adina_post_query->have_posts() ) {
				$adina_post_query->the_post();
				$adina_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $adina_builder_post_title;

		}

		public function adina_header_choose_option(){

			$adina_post_query = new WP_Query( array(
				'post_type'			=> 'adina_header',
				'posts_per_page'	    => -1,
			) );

			$adina_builder_post_title = array();
			$adina_builder_post_title[''] = __('Select a Header','Adina');

			while( $adina_post_query->have_posts() ) {
				$adina_post_query->the_post();
				$adina_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $adina_builder_post_title;

        }

    }

    $builder_execute = new AdinaBuilder();