<?php
// File Security Check
if (!defined('ABSPATH')) {
	exit;
}
class AdinaCustomPosts{

    function __construct()
	{   
        /*----------  Service ----------*/
        add_action('init', array($this, 'adina_service'));


        /*----------  Team ----------*/
        add_action('init', array($this, 'adina_team'));

        /*----------  Project ----------*/
        add_action('init', array($this, 'adina_project'));
        add_action('init', array($this, 'adina_project_category'));
    }

    /*----------  Service ----------*/   
    public function adina_service() 
    {
        $labels = array(
            'name'               => esc_html__( 'Services', 'Service general name', 'adina' ),
            'singular_name'      => esc_html__( 'Service', 'Service singular name', 'adina' ),
            'menu_name'          => esc_html__( 'Services', 'admin menu', 'adina' ),
            'name_admin_bar'     => esc_html__( 'Service', 'add new on admin bar', 'adina' ),
            'add_new'            => esc_html__( 'Add New', 'Service', 'adina' ),
            'add_new_item'       => esc_html__( 'Add New Service', 'adina' ),
            'new_item'           => esc_html__( 'New Service', 'adina' ),
            'edit_item'          => esc_html__( 'Edit Service', 'adina' ),
            'view_item'          => esc_html__( 'View Service', 'adina' ),
            'all_items'          => esc_html__( 'All Service', 'adina' ),
            'search_items'       => esc_html__( 'Search Service', 'adina' ),
            'parent_item_colon'  => esc_html__( 'Parent Service:', 'adina' ),
            'not_found'          => esc_html__( 'No Service found.', 'adina' ),
            'not_found_in_trash' => esc_html__( 'No Service found in Trash.', 'adina' ),
        );
    
        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'adina' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-edit-page',
            'supports'           => array( 'title','thumbnail','editor','excerpt','elementor' ),
            'rewrite'            => array( 'slug' => 'services' ),
        );
        register_post_type( 'adina_service', $args );
    }


    /*----------  Team ----------*/   
    public function adina_team() 
    {
        $labels = array(
            'name'               => esc_html__( 'Teams', 'Team general name', 'adina' ),
            'singular_name'      => esc_html__( 'Team', 'Team singular name', 'adina' ),
            'menu_name'          => esc_html__( 'Teams', 'admin menu', 'adina' ),
            'name_admin_bar'     => esc_html__( 'Team', 'add new on admin bar', 'adina' ),
            'add_new'            => esc_html__( 'Add New', 'Team', 'adina' ),
            'add_new_item'       => esc_html__( 'Add New Team', 'adina' ),
            'new_item'           => esc_html__( 'New Team', 'adina' ),
            'edit_item'          => esc_html__( 'Edit Team', 'adina' ),
            'view_item'          => esc_html__( 'View Team', 'adina' ),
            'all_items'          => esc_html__( 'All Team', 'adina' ),
            'search_items'       => esc_html__( 'Search Team', 'adina' ),
            'parent_item_colon'  => esc_html__( 'Parent Team:', 'adina' ),
            'not_found'          => esc_html__( 'No Team found.', 'adina' ),
            'not_found_in_trash' => esc_html__( 'No Team found in Trash.', 'adina' ),
        );
    
        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'adina' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-id',
            'supports'           => array( 'title','thumbnail','editor','elementor' ),
            'rewrite'            => array( 'slug' => 'teams' ),
        );
        register_post_type( 'adina_team', $args );
    }


    /*----------  Project ----------*/   
    public function adina_project() 
    {
        $labels = array(
            'name'               => esc_html__( 'Projects', 'Project general name', 'adina' ),
            'singular_name'      => esc_html__( 'Project', 'Project singular name', 'adina' ),
            'menu_name'          => esc_html__( 'Projects', 'admin menu', 'adina' ),
            'name_admin_bar'     => esc_html__( 'Project', 'add new on admin bar', 'adina' ),
            'add_new'            => esc_html__( 'Add New', 'Project', 'adina' ),
            'add_new_item'       => esc_html__( 'Add New Project', 'adina' ),
            'new_item'           => esc_html__( 'New Project', 'adina' ),
            'edit_item'          => esc_html__( 'Edit Project', 'adina' ),
            'view_item'          => esc_html__( 'View Project', 'adina' ),
            'all_items'          => esc_html__( 'All Projects', 'adina' ),
            'search_items'       => esc_html__( 'Search Projects', 'adina' ),
            'parent_item_colon'  => esc_html__( 'Parent Projects:', 'adina' ),
            'not_found'          => esc_html__( 'No Projects found.', 'adina' ),
            'not_found_in_trash' => esc_html__( 'No Projects found in Trash.', 'adina' ),
        );
    
        $args = array(
            'labels'             => $labels,
            'description'        => esc_html__( 'Description.', 'adina' ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'show_in_rest'       => true,
            'menu_icon'          => 'dashicons-portfolio',
            'supports'           => array( 'title','thumbnail','editor','excerpt','elementor' ),
            'rewrite'            => array( 'slug' => 'projects' ),
        );
        register_post_type( 'adina_project', $args );
    }

    // Project Category
    public function adina_project_category() {

        $labels = array(
            'name'                       => esc_html__( 'Categories', 'taxonomy general name', 'adina' ),
            'singular_name'              => esc_html__( 'Category', 'taxonomy singular name', 'adina' ),
            'search_items'               => esc_html__( 'Search Categorys', 'adina' ),
            'popular_items'              => esc_html__( 'Popular Categorys', 'adina' ),
            'all_items'                  => esc_html__( 'All Categorys', 'adina' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => esc_html__( 'Edit Category', 'adina' ),
            'update_item'                => esc_html__( 'Update Category', 'adina' ),
            'add_new_item'               => esc_html__( 'Add New Category', 'adina' ),
            'new_item_name'              => esc_html__( 'New Category Name', 'adina' ),
            'separate_items_with_commas' => esc_html__( 'Separate Categorys with commas', 'adina' ),
            'add_or_remove_items'        => esc_html__( 'Add or remove Categorys', 'adina' ),
            'choose_from_most_used'      => esc_html__( 'Choose from the most used Categorys', 'adina' ),
            'not_found'                  => esc_html__( 'No Categorys found.', 'adina' ),
            'menu_name'                  => esc_html__( 'Categories', 'adina' ),
        );
    
        $args = array(
            'hierarchical'          => true,
            'labels'                => $labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'update_count_callback' => '_update_post_term_count',
            'query_var'             => true,
            'show_in_rest'          => true,
            'rewrite'               => array( 'slug' => 'project-cat' ),
        );
        register_taxonomy( 'project_category', 'adina_project', $args );
    }
    
}
$Adina_StydyInstance = new AdinaCustomPosts;

