<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Meta Output
 *
 * @since 1.0
 *
 * @return array
 */
if ( ! function_exists( 'adina_get_meta' ) ) {
    function adina_get_meta( $data ) {
        global $wp_embed;
        $content = $wp_embed->autoembed( $data );
        $content = $wp_embed->run_shortcode( $content );
        $content = do_shortcode( $content );
        $content = wpautop( $content );
        return $content;
    }
}

function adina_cpt_taxonomy_slug_and_name($taxonomy_name, $option_tag = false)
{
    $taxonomyies = get_terms($taxonomy_name);
    if(true == $option_tag){
        $cpt_terms = '';
        foreach ($taxonomyies as $category) {
            if( isset( $category->slug ) && isset( $category->name ) ){
               $cpt_terms .= '<option value="'. esc_attr( $category->slug) .'">'.  $category->name .'</option>';
            }
        }
        return $cpt_terms;
    }
    $cpt_terms = [];
    foreach ($taxonomyies as $category) {
        if( isset( $category->slug ) && isset( $category->name ) ){
            $cpt_terms[$category->slug] = $category->name;
        }
    }
    return $cpt_terms;
}

function adina_cpt_taxonomy_id_and_name($taxonomy_name)
{
    $taxonomyies = get_terms($taxonomy_name);
    $cpt_terms = [];
    foreach ($taxonomyies as $category) {
        $cpt_terms[$category->term_id] = $category->name;
    }
    return $cpt_terms;
}

function adina_cpt_author_slug_and_id($post_type)
{
    $the_query = new WP_Query(array(
        'posts_per_page' => -1,
        'post_type' => $post_type,
    ));
    $author_meta = [];
    while ($the_query->have_posts()) : $the_query->the_post();
        $author_meta[get_the_author_meta('ID')] = get_the_author_meta('display_name');
    endwhile;
    wp_reset_postdata();
    return array_unique($author_meta);
}
function adina_cpt_slug_and_id($post_type)
{
    $the_query = new WP_Query(array(
        'posts_per_page' => -1,
        'post_type' => $post_type,
    ));
    $cpt_posts = [];
    while ($the_query->have_posts()) : $the_query->the_post();
        $cpt_posts[get_the_ID()] = get_the_title();
    endwhile;
    wp_reset_postdata();
    return $cpt_posts;
}

function adina_get_meta_field_keys($post_type, $field_name, $fild_type = "choices")
{
    $the_query = new WP_Query(array(
        'posts_per_page' => 1,
        'post_type' => $post_type,
    ));

    $field_object = [];
    while ($the_query->have_posts()) : $the_query->the_post();
    $field_object = isset(get_field_object($field_name)[$fild_type]) ? get_field_object($field_name)[$fild_type] : false;
    endwhile;
    return $field_object;
    wp_reset_postdata();
}

function adina_start_modify_html() {
    ob_start();
 }
 function adina_end_modify_html() {
    $html = ob_get_clean();
    $html = str_replace( 'font-display:swap;', '', $html );
    echo $html;
 }
 add_action( 'wp_head', 'adina_start_modify_html' );
 add_action( 'wp_footer', 'adina_end_modify_html' );

//sakib

/**
 * Checking post type enablee or disabled
 */
function adina_check_cpt( $opt_id ){
    $adina = get_option( 'adina' );
    if( isset( $adina[$opt_id] ) ){
        if( true == $adina[$opt_id] ) {
            return true;
        }else{
            return false;
        }
    }else{
        return true;
    }
}
 /**
 * Check if contact form 7 is activated
 *
 * @return bool
 */
if ( ! function_exists( 'adina_is_cf7_activated' ) ) {
    function adina_is_cf7_activated() {
        return class_exists( 'WPCF7' );
    }
}


function adina_layout_content($post_id){

	return Elementor\Plugin::instance()->frontend->get_builder_content($post_id, true);
};

/**
 * Post orderby list
 */
function adina_get_post_orderby_options()
{
    $orderby = array(
        'ID' => 'Post ID',
        'author' => 'Post Author',
        'title' => 'Title',
        'date' => 'Date',
        'modified' => 'Last Modified Date',
        'parent' => 'Parent Id',
        'rand' => 'Random',
        'comment_count' => 'Comment Count',
        'menu_order' => 'Menu Order',
    );
    $orderby = apply_filters('adina_post_orderby', $orderby);
    return $orderby;
}

/**
 * Get Posts
 *
 * @since 1.0
 *
 * @return array
 */
if ( ! function_exists( 'adina_get_all_posts' ) ) {
    function adina_get_all_posts($posttype)
    {
        $args = array(
            'post_type' => $posttype,
            'post_status' => 'publish',
            'posts_per_page' => -1
        );

        $post_list = array();
        if( $data = get_posts($args)){
            foreach($data as $key){
                $post_list[$key->ID] = $key->post_title;
            }
        }
        return  $post_list;
    }
}


// Get All projects
if ( ! function_exists( 'get_all_projects' ) ) {
    function get_all_projects() {
        $wp_query = get_posts([
            'post_type' => 'adina_project',
            'orderby' => 'date',
            'posts_per_page' => -1,
        ]);

        $options = ['none' => 'None'];
        foreach ($wp_query as $projects) {
            $options[$projects->ID] = $projects->post_title;
        }

        return $options;
    }
}

if ( ! function_exists( 'adina_post_excerpt' ) ) :
/**
 * Display post post excerpt or content
 * *
 * @since 1.0
 */
function adina_post_excerpt($post_id, $length = 20) {
    $post_object = get_post( $post_id );
    $excerpt = $post_object->post_excerpt;
    $content = $post_object->post_content;

    if ( !empty($excerpt)  && strlen(trim($excerpt)) != 0) {
        echo '<p>' . wp_trim_words( $excerpt, (int)$length, '' ) . '</p>';
    } else {
        echo '<p>' . wp_trim_words( $content, (int)$length, '' ) . '</p>';
    }

}
endif;


// function adina_modify_jquery() {

//     //check if front-end is being viewed
//     if (!is_admin()) {

//         // Remove default WordPress jQuery
//         wp_deregister_script('jquery');

//         // Register new jQuery script via Google Library    
//         wp_register_script( 'jquery', ADINA_PLUGDIRURI . 'assets/js/jquery-3.6.0.min.js',  false, microtime());
       
//         // Enqueue the script   
//         wp_enqueue_script('');
//     }
// }

// add_action( 'wp_enqueue_scripts', 'adina_modify_jquery' );




























